/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matchers;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.ParameterUtils;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallbackChecker;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallbackParameters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformOperations;
import java.util.Objects;

public class TransformTemplate
implements TransformOperations {
    private final InstrumentContext instrumentContext;

    public TransformTemplate(InstrumentContext instrumentContext) {
        this.instrumentContext = Objects.requireNonNull(instrumentContext, "instrumentContext");
    }

    protected InstrumentContext getInstrumentContext() {
        return this.instrumentContext;
    }

    @Override
    @Deprecated
    public void transform(String className, TransformCallback transformCallback) {
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(transformCallback, "transformCallback");
        Matcher matcher = Matchers.newClassNameMatcher(className);
        this.instrumentContext.addClassFileTransformer(matcher, transformCallback);
    }

    @Override
    public void transform(String className, Class<? extends TransformCallback> transformCallbackClass) {
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(transformCallbackClass, "transformCallbackClass");
        Matcher matcher = Matchers.newClassNameMatcher(className);
        TransformCallbackChecker.validate(transformCallbackClass);
        String transformCallbackName = transformCallbackClass.getName();
        this.instrumentContext.addClassFileTransformer(matcher, transformCallbackName);
    }

    @Override
    public void transform(String className, Class<? extends TransformCallback> transformCallbackClass, Object[] parameters, Class<?>[] parameterTypes) {
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(transformCallbackClass, "transformCallbackClass");
        TransformCallbackChecker.validate(transformCallbackClass, parameterTypes);
        if (ParameterUtils.hasNull(parameterTypes)) {
            throw new IllegalArgumentException("null parameterType not supported");
        }
        ParameterUtils.checkParameterType(parameterTypes);
        Matcher matcher = Matchers.newClassNameMatcher(className);
        String transformCallbackName = transformCallbackClass.getName();
        this.instrumentContext.addClassFileTransformer(matcher, transformCallbackName, parameters, parameterTypes);
    }

    @Override
    public void transform(String className, Class<? extends TransformCallback> transformCallbackClass, TransformCallbackParameters params) {
        Object[] parameters = params.getParamValues();
        Class<?>[] parameterTypes = params.getParamTypes();
        this.transform(className, transformCallbackClass, parameters, parameterTypes);
    }
}

