/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncContextUtils;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import java.util.Objects;

public abstract class AbstractAsyncContextSpanEventEndPointInterceptor {
    protected final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final TraceContext traceContext;

    public AbstractAsyncContextSpanEventEndPointInterceptor(TraceContext traceContext) {
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
    }

    protected AsyncContext getAsyncContext(Object target, Object[] args) {
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    protected AsyncContext getAsyncContext(Object target, Object[] args, Object result, Throwable throwable) {
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    protected Trace getAsyncTrace(AsyncContext asyncContext) {
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            return null;
        }
        return trace;
    }

    protected void deleteAsyncTrace(Trace trace) {
        this.traceContext.removeTraceObject();
        trace.close();
    }

    protected void finishAsyncState(AsyncContext asyncContext) {
        if (AsyncContextUtils.asyncStateFinish(asyncContext) && this.isDebug) {
            this.logger.debug("finished asyncState. asyncTraceId={}", (Object)asyncContext);
        }
    }
}

