/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.View;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.Pair;
import org.apache.eventmesh.metrics.api.model.InstrumentFurther;
import org.apache.eventmesh.metrics.api.model.InstrumentType;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.ObservableMetric;
import org.apache.eventmesh.metrics.api.model.SyncMetric;

public final class PrometheusMetricsRegistryManager {
    private static final Map<String, Meter> meterCache = new ConcurrentHashMap<String, Meter>(32);
    private static final Map<String, Set<Metric>> metricCache = new ConcurrentHashMap<String, Set<Metric>>(16);

    public static void registerMetric(Metric metric) {
        Set metrics = metricCache.computeIfAbsent(metric.getName(), k -> new HashSet());
        metrics.add(metric);
    }

    protected static Set<Metric> getMetrics(String metricName) {
        return metricCache.get(metricName);
    }

    public static void createMetric(OpenTelemetry openTelemetry) {
        metricCache.values().stream().flatMap(metricSet -> metricSet.stream()).forEach(metric -> {
            Meter meter = meterCache.computeIfAbsent(metric.getName(), meterName -> openTelemetry.getMeter(meterName));
            InstrumentFurther instrumentFurther = metric.getInstrumentFurther();
            if (instrumentFurther == null) {
                instrumentFurther = new InstrumentFurther();
            }
            if (metric instanceof ObservableMetric) {
                PrometheusMetricsRegistryManager.handleObservableMetric((ObservableMetric)metric, meter, instrumentFurther);
                return;
            }
            if (metric instanceof SyncMetric) {
                PrometheusMetricsRegistryManager.handleMetric((SyncMetric)metric, meter, instrumentFurther);
            }
        });
    }

    public static List<Pair<InstrumentSelector, View>> getMetricsView() {
        Collection<Set<Metric>> metricSetCollection = metricCache.values();
        return metricSetCollection.stream().map(metricSet -> metricSet.stream().map(metric -> {
            InstrumentFurther instrumentFurther = metric.getInstrumentFurther();
            if (!Objects.nonNull(instrumentFurther)) {
                return null;
            }
            Map ext = instrumentFurther.getExt();
            if (!Objects.nonNull(ext)) {
                return null;
            }
            return (Pair)ext.get("instrument_view");
        }).filter(pair -> pair != null).collect(Collectors.toList())).flatMap(viewSet -> viewSet.stream()).collect(Collectors.toList());
    }

    private static void handleMetric(SyncMetric metric, Meter meter, InstrumentFurther instrumentFurther) {
        InstrumentType instrumentType = metric.getInstrumentType();
        switch (instrumentType) {
            case LONG_COUNTER: {
                LongCounter counter = meter.counterBuilder(instrumentFurther.getName()).setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).build();
                metric.setInstrument((Object)counter);
                break;
            }
            case DOUBLE_COUNTER: {
                DoubleCounter counter = meter.counterBuilder(instrumentFurther.getName()).ofDoubles().setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).build();
                metric.setInstrument((Object)counter);
                break;
            }
            case LONG_HISTOGRAM: {
                LongHistogram histogram = meter.histogramBuilder(instrumentFurther.getName()).ofLongs().setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).build();
                metric.setInstrument((Object)histogram);
                break;
            }
            case DOUBLE_HISTOGRAM: {
                DoubleHistogram histogram = meter.histogramBuilder(instrumentFurther.getName()).setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).build();
                metric.setInstrument((Object)histogram);
                break;
            }
            case LONG_UP_DOWN_COUNTER: {
                LongUpDownCounter counter = meter.upDownCounterBuilder(instrumentFurther.getName()).setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).build();
                metric.setInstrument((Object)counter);
                break;
            }
            case DOUBLE_UP_DOWN_COUNTER: {
                DoubleUpDownCounter counter = meter.upDownCounterBuilder(instrumentFurther.getName()).ofDoubles().setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).build();
                metric.setInstrument((Object)counter);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s not Support", instrumentType.getType().getName()));
            }
        }
    }

    private static void handleObservableMetric(ObservableMetric<String, String, ?> observableMetric, Meter meter, InstrumentFurther instrumentFurther) {
        InstrumentType instrumentType = observableMetric.getInstrumentType();
        Attributes attributes = PrometheusMetricsRegistryManager.buildAttributes(observableMetric);
        switch (instrumentType) {
            case OBSERVABLE_LONG_GAUGE: {
                meter.gaugeBuilder(instrumentFurther.getName()).ofLongs().setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).buildWithCallback(measurement -> measurement.record(((Long)Objects.requireNonNull(observableMetric.supplier()).get()).longValue(), attributes));
                break;
            }
            case OBSERVABLE_DOUBLE_GAUGE: {
                meter.gaugeBuilder(instrumentFurther.getName()).setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).buildWithCallback(measurement -> measurement.record(((Double)Objects.requireNonNull(observableMetric.supplier()).get()).doubleValue(), attributes));
                break;
            }
            case OBSERVABLE_LONG_COUNTER: {
                meter.counterBuilder(instrumentFurther.getName()).setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).buildWithCallback(measurement -> measurement.record(((Long)Objects.requireNonNull(observableMetric.supplier()).get()).longValue(), attributes));
                break;
            }
            case OBSERVABLE_DOUBLE_COUNTER: {
                meter.counterBuilder(instrumentFurther.getName()).ofDoubles().setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).buildWithCallback(measurement -> measurement.record(((Double)Objects.requireNonNull(observableMetric.supplier()).get()).doubleValue(), attributes));
                break;
            }
            case OBSERVABLE_LONG_UP_DOWN_COUNTER: {
                meter.upDownCounterBuilder(instrumentFurther.getName()).setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).buildWithCallback(measurement -> measurement.record(((Long)Objects.requireNonNull(observableMetric.supplier()).get()).longValue(), attributes));
                break;
            }
            case OBSERVABLE_DOUBLE_UP_DOWN_COUNTER: {
                meter.upDownCounterBuilder(instrumentFurther.getName()).ofDoubles().setDescription(instrumentFurther.getDescription()).setUnit(instrumentFurther.getUnit()).buildWithCallback(measurement -> measurement.record(((Double)Objects.requireNonNull(observableMetric.supplier()).get()).doubleValue(), attributes));
                break;
            }
        }
    }

    private static Attributes buildAttributes(ObservableMetric<String, String, ?> observableMetric) {
        Map attributes = observableMetric.getAttributes();
        AttributesBuilder builder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    @Generated
    private PrometheusMetricsRegistryManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

