/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.api.monitor;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.apache.eventmesh.openconnect.api.monitor.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectorMonitor
implements Monitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectorMonitor.class);
    private final String taskId;
    private final String jobId;
    private final String ip;
    private final LongAdder totalRecordNum;
    private final LongAdder totalTimeCost;
    protected final AtomicLong startTime;
    private final AtomicLong maxTimeCost;
    private long averageTime = 0L;
    private double tps = 0.0;

    public AbstractConnectorMonitor(String taskId, String jobId, String ip) {
        this.taskId = taskId;
        this.jobId = jobId;
        this.ip = ip;
        this.totalRecordNum = new LongAdder();
        this.totalTimeCost = new LongAdder();
        this.startTime = new AtomicLong(System.currentTimeMillis());
        this.maxTimeCost = new AtomicLong();
    }

    @Override
    public synchronized void recordProcess(long timeCost) {
        this.totalRecordNum.increment();
        this.totalTimeCost.add(timeCost);
        this.maxTimeCost.updateAndGet(max -> Math.max(max, timeCost));
    }

    @Override
    public synchronized void recordProcess(int recordCount, long timeCost) {
        this.totalRecordNum.add(recordCount);
        this.totalTimeCost.add(timeCost);
        this.maxTimeCost.updateAndGet(max -> Math.max(max, timeCost));
    }

    @Override
    public synchronized void printMetrics() {
        long totalRecords = this.totalRecordNum.sum();
        long totalCost = this.totalTimeCost.sum();
        this.averageTime = totalRecords > 0L ? totalCost / totalRecords : 0L;
        long elapsedTime = (System.currentTimeMillis() - this.startTime.get()) / 1000L;
        this.tps = elapsedTime > 0L ? (double)totalRecords / (double)elapsedTime : 0.0;
        log.info("========== Metrics ==========");
        log.info("TaskId: {}|JobId: {}|ip: {}", new Object[]{this.taskId, this.jobId, this.ip});
        log.info("Total records: {}", (Object)this.totalRecordNum);
        log.info("Total time (ms): {}", (Object)this.totalTimeCost);
        log.info("Max time per record (ms): {}", (Object)this.maxTimeCost);
        log.info("Average time per record (ms): {}", (Object)this.averageTime);
        log.info("TPS: {}", (Object)this.tps);
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public LongAdder getTotalRecordNum() {
        return this.totalRecordNum;
    }

    @Generated
    public LongAdder getTotalTimeCost() {
        return this.totalTimeCost;
    }

    @Generated
    public AtomicLong getStartTime() {
        return this.startTime;
    }

    @Generated
    public AtomicLong getMaxTimeCost() {
        return this.maxTimeCost;
    }

    @Generated
    public long getAverageTime() {
        return this.averageTime;
    }

    @Generated
    public double getTps() {
        return this.tps;
    }
}

