/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.profiler.context.CloseListener;
import com.navercorp.pinpoint.profiler.context.DisableTrace;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import java.util.Objects;

public class AsyncDisableTrace
extends DisableTrace {
    private final AsyncState asyncState;

    public AsyncDisableTrace(LocalTraceRoot traceRoot, SpanRecorder spanRecorder, SpanEventRecorder spanEventRecorder, AsyncState asyncState) {
        super(traceRoot, spanRecorder, spanEventRecorder, CloseListener.EMPTY);
        this.asyncState = Objects.requireNonNull(asyncState, "asyncState");
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            this.logger.debug("Already closed");
            return;
        }
        if (this.asyncState.await()) {
            super.flush();
            if (this.isDebug) {
                this.logger.debug("Await trace={}, asyncState={}", (Object)this, (Object)this.asyncState);
            }
        } else {
            super.close();
            if (this.isDebug) {
                this.logger.debug("Close trace={}. asyncState={}", (Object)this, (Object)this.asyncState);
            }
        }
    }

    public String toString() {
        return "AsyncDisableTrace{asyncState=" + this.asyncState + "} " + super.toString();
    }
}

