/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.AsyncContexts;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.Binder;
import com.navercorp.pinpoint.profiler.context.id.AsyncIdGenerator;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.method.PredefinedMethodDescriptorRegistry;
import java.util.Objects;

public class DefaultAsyncContextFactory
implements AsyncContextFactory {
    private final AsyncContexts.Remote remote;
    private final AsyncContexts.Local local;
    private final AsyncIdGenerator asyncIdGenerator;

    public DefaultAsyncContextFactory(AsyncTraceContext asyncTraceContext, Binder<Trace> binder, AsyncIdGenerator asyncIdGenerator, PredefinedMethodDescriptorRegistry predefinedMethodDescriptorRegistry) {
        int asyncMethodApiId = this.getAsyncMethodApiId(predefinedMethodDescriptorRegistry);
        this.remote = AsyncContexts.remote(asyncTraceContext, binder, asyncMethodApiId);
        this.local = AsyncContexts.local(asyncTraceContext, binder);
        this.asyncIdGenerator = Objects.requireNonNull(asyncIdGenerator, "asyncIdGenerator");
    }

    private int getAsyncMethodApiId(PredefinedMethodDescriptorRegistry predefinedMethodDescriptorRegistry) {
        MethodDescriptor asyncMethodDescriptor = predefinedMethodDescriptorRegistry.getAsyncMethodDescriptor();
        return asyncMethodDescriptor.getApiId();
    }

    @Override
    public AsyncId newAsyncId() {
        return this.asyncIdGenerator.newAsyncId();
    }

    @Override
    public AsyncContext newAsyncContext(TraceRoot traceRoot, AsyncId asyncId, boolean canSampled) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        Objects.requireNonNull(asyncId, "asyncId");
        if (canSampled) {
            return this.remote.sync(traceRoot, asyncId);
        }
        return this.newDisableAsyncContext(traceRoot);
    }

    @Override
    public AsyncContext newAsyncContext(TraceRoot traceRoot, AsyncId asyncId, boolean canSampled, AsyncState asyncState) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        Objects.requireNonNull(asyncId, "asyncId");
        Objects.requireNonNull(asyncState, "asyncState");
        if (canSampled) {
            return this.remote.async(traceRoot, asyncState, asyncId);
        }
        return this.newDisableAsyncContext(traceRoot, asyncState);
    }

    @Override
    public AsyncContext newDisableAsyncContext(LocalTraceRoot traceRoot) {
        return this.local.sync(traceRoot);
    }

    @Override
    public AsyncContext newDisableAsyncContext(LocalTraceRoot traceRoot, AsyncState asyncState) {
        return this.local.async(traceRoot, asyncState);
    }
}

