/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAgentInfoMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcExceptionMetaDataConverter;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcMetadataMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.MessageConverterGroup;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentInfoMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ExceptionMetaDataMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.MetaDataMapper;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import java.util.Arrays;
import java.util.Objects;

public class GrpcMetadataMessageConverterProvider
implements Provider<MessageConverter<MetaDataType, GeneratedMessageV3>> {
    private final MetaDataMapper metaDataMapper;
    private final AgentInfoMapper agentInfoMapper;
    private final ExceptionMetaDataMapper exceptionMetaDataMapper;

    @Inject
    public GrpcMetadataMessageConverterProvider(MetaDataMapper metaDataMapper, AgentInfoMapper agentInfoMapper, ExceptionMetaDataMapper exceptionMetaDataMapper) {
        this.metaDataMapper = Objects.requireNonNull(metaDataMapper, "metaDataMapper");
        this.agentInfoMapper = Objects.requireNonNull(agentInfoMapper, "agentInfoMapper");
        this.exceptionMetaDataMapper = Objects.requireNonNull(exceptionMetaDataMapper, "exceptionMetaDataMapper");
    }

    public MessageConverter<MetaDataType, GeneratedMessageV3> get() {
        GrpcMetadataMessageConverter metadataMessageConverter = new GrpcMetadataMessageConverter(this.metaDataMapper);
        GrpcAgentInfoMessageConverter agentMessageConverter = new GrpcAgentInfoMessageConverter(this.agentInfoMapper);
        GrpcExceptionMetaDataConverter exceptionMessageConverter = new GrpcExceptionMetaDataConverter(this.exceptionMetaDataMapper);
        return MessageConverterGroup.wrap(Arrays.asList(metadataMessageConverter, agentMessageConverter, exceptionMessageConverter));
    }
}

