/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.profiler.logging.ThrottledLogger;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.SpanMessageMapper;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcSpanMessageConverter
implements MessageConverter<SpanType, GeneratedMessageV3> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ThrottledLogger throttledLogger = ThrottledLogger.getLogger((Logger)this.logger, (long)100L);
    private final String agentId;
    private final short applicationServiceType;
    private final SpanProcessor<PSpan.Builder, PSpanChunk.Builder> spanProcessor;
    private final SpanMessageMapper mapper;

    public GrpcSpanMessageConverter(String agentId, short applicationServiceType, SpanProcessor<PSpan.Builder, PSpanChunk.Builder> spanProcessor, SpanMessageMapper spanMessageMapper) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.applicationServiceType = applicationServiceType;
        this.spanProcessor = Objects.requireNonNull(spanProcessor, "spanProcessor");
        this.mapper = Objects.requireNonNull(spanMessageMapper, "spanMessageMapper");
    }

    public GeneratedMessageV3 toMessage(SpanType message) {
        if (message instanceof SpanChunk) {
            SpanChunk spanChunk = (SpanChunk)message;
            return this.buildPSpanChunk(spanChunk);
        }
        if (message instanceof Span) {
            Span span = (Span)message;
            return this.buildPSpan(span);
        }
        return null;
    }

    @VisibleForTesting
    PSpan buildPSpan(Span span) {
        PSpan.Builder pSpan = PSpan.newBuilder();
        this.spanProcessor.preProcess(span, pSpan);
        this.mapper.map(span, this.applicationServiceType, pSpan);
        this.spanProcessor.postProcess(span, pSpan);
        return pSpan.build();
    }

    @VisibleForTesting
    PSpanChunk buildPSpanChunk(SpanChunk spanChunk) {
        PSpanChunk.Builder pSpanChunk = PSpanChunk.newBuilder();
        this.spanProcessor.preProcess(spanChunk, pSpanChunk);
        this.mapper.map(spanChunk, this.applicationServiceType, pSpanChunk);
        this.spanProcessor.postProcess(spanChunk, pSpanChunk);
        return pSpanChunk.build();
    }

    public String toString() {
        return "GrpcSpanMessageConverter{agentId='" + this.agentId + '\'' + ", applicationServiceType=" + this.applicationServiceType + ", spanProcessor=" + this.spanProcessor + '}';
    }
}

