/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.ChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.DefaultChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.grpc.client.UnaryCallDeadlineInterceptor;
import com.navercorp.pinpoint.grpc.client.config.ClientOption;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ThreadDumpMapper;
import com.navercorp.pinpoint.profiler.context.module.AgentDataSender;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandLocatorBuilder;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcActiveThreadCountService;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcActiveThreadDumpService;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcActiveThreadLightDumpService;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcEchoService;
import com.navercorp.pinpoint.profiler.sender.grpc.AgentGrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import io.grpc.ClientInterceptor;
import io.grpc.NameResolverProvider;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentGrpcDataSenderProvider
implements Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final GrpcTransportConfig grpcTransportConfig;
    private final MessageConverter<MetaDataType, GeneratedMessageV3> messageConverter;
    private final HeaderFactory headerFactory;
    private final Provider<ReconnectExecutor> reconnectExecutorProvider;
    private final ScheduledExecutorService retransmissionExecutor;
    private final NameResolverProvider nameResolverProvider;
    private final ActiveTraceRepository activeTraceRepository;
    private List<ClientInterceptor> clientInterceptorList;
    private final Provider<SslContext> sslContextProvider;
    private final ThreadDumpMapper threadDumpMapper;

    @Inject
    public AgentGrpcDataSenderProvider(GrpcTransportConfig grpcTransportConfig, @MetadataDataSender MessageConverter<MetaDataType, GeneratedMessageV3> messageConverter, HeaderFactory headerFactory, Provider<ReconnectExecutor> reconnectExecutor, ScheduledExecutorService retransmissionExecutor, NameResolverProvider nameResolverProvider, ActiveTraceRepository activeTraceRepository, Provider<SslContext> sslContextProvider, ThreadDumpMapper threadDumpMapper) {
        this.grpcTransportConfig = Objects.requireNonNull(grpcTransportConfig, "grpcTransportConfig");
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
        this.headerFactory = Objects.requireNonNull(headerFactory, "headerFactory");
        this.reconnectExecutorProvider = Objects.requireNonNull(reconnectExecutor, "reconnectExecutorProvider");
        this.retransmissionExecutor = Objects.requireNonNull(retransmissionExecutor, "retransmissionExecutor");
        this.nameResolverProvider = Objects.requireNonNull(nameResolverProvider, "nameResolverProvider");
        this.activeTraceRepository = Objects.requireNonNull(activeTraceRepository, "activeTraceRepository");
        this.sslContextProvider = Objects.requireNonNull(sslContextProvider, "sslContextProvider");
        this.threadDumpMapper = Objects.requireNonNull(threadDumpMapper, "threadDumpMapper");
    }

    @Inject(optional=true)
    public void setClientInterceptor(@AgentDataSender List<ClientInterceptor> clientInterceptorList) {
        this.clientInterceptorList = Objects.requireNonNull(clientInterceptorList, "clientInterceptorList");
    }

    public EnhancedDataSender<MetaDataType, ResponseMessage> get() {
        String collectorIp = this.grpcTransportConfig.getAgentCollectorIp();
        int collectorPort = this.grpcTransportConfig.getAgentCollectorPort();
        boolean sslEnable = this.grpcTransportConfig.isAgentSslEnable();
        int senderExecutorQueueSize = this.grpcTransportConfig.getAgentSenderExecutorQueueSize();
        ChannelFactoryBuilder channelFactoryBuilder = this.newChannelFactoryBuilder(sslEnable);
        ChannelFactory channelFactory = channelFactoryBuilder.build();
        ReconnectExecutor reconnectExecutor = (ReconnectExecutor)this.reconnectExecutorProvider.get();
        ProfilerCommandServiceLocator profilerCommandServiceLocator = this.createProfilerCommandServiceLocator(this.activeTraceRepository);
        MessageConverter<MetaDataType, GeneratedMessageV3> messageConverter = this.messageConverter;
        return this.newAgentGrpcDataSender(collectorIp, collectorPort, senderExecutorQueueSize, messageConverter, channelFactory, reconnectExecutor, this.retransmissionExecutor, profilerCommandServiceLocator);
    }

    protected EnhancedDataSender<MetaDataType, ResponseMessage> newAgentGrpcDataSender(String collectorIp, int collectorPort, int senderExecutorQueueSize, MessageConverter<MetaDataType, GeneratedMessageV3> messageConverter, ChannelFactory channelFactory, ReconnectExecutor reconnectExecutor, ScheduledExecutorService retransmissionExecutor, ProfilerCommandServiceLocator profilerCommandServiceLocator) {
        return new AgentGrpcDataSender<MetaDataType>(collectorIp, collectorPort, senderExecutorQueueSize, messageConverter, reconnectExecutor, retransmissionExecutor, channelFactory, profilerCommandServiceLocator);
    }

    ChannelFactoryBuilder newChannelFactoryBuilder(boolean sslEnable) {
        int channelExecutorQueueSize = this.grpcTransportConfig.getAgentChannelExecutorQueueSize();
        UnaryCallDeadlineInterceptor unaryCallDeadlineInterceptor = new UnaryCallDeadlineInterceptor(this.grpcTransportConfig.getAgentRequestTimeout());
        ClientOption clientOption = this.grpcTransportConfig.getAgentClientOption();
        DefaultChannelFactoryBuilder channelFactoryBuilder = new DefaultChannelFactoryBuilder("AgentGrpcDataSender");
        channelFactoryBuilder.setHeaderFactory(this.headerFactory);
        channelFactoryBuilder.setNameResolverProvider(this.nameResolverProvider);
        channelFactoryBuilder.addClientInterceptor((ClientInterceptor)unaryCallDeadlineInterceptor);
        if (this.clientInterceptorList != null) {
            for (ClientInterceptor clientInterceptor : this.clientInterceptorList) {
                this.logger.info("addClientInterceptor:{}", (Object)clientInterceptor);
                channelFactoryBuilder.addClientInterceptor(clientInterceptor);
            }
        }
        channelFactoryBuilder.setExecutorQueueSize(channelExecutorQueueSize);
        channelFactoryBuilder.setClientOption(clientOption);
        if (sslEnable) {
            SslContext sslContext = (SslContext)this.sslContextProvider.get();
            channelFactoryBuilder.setSslContext(sslContext);
        }
        return channelFactoryBuilder;
    }

    private ProfilerCommandServiceLocator createProfilerCommandServiceLocator(ActiveTraceRepository activeTraceRepository) {
        ProfilerCommandLocatorBuilder profilerCommandLocatorBuilder = new ProfilerCommandLocatorBuilder();
        profilerCommandLocatorBuilder.addService(new GrpcEchoService());
        if (activeTraceRepository != null) {
            profilerCommandLocatorBuilder.addService(new GrpcActiveThreadCountService(activeTraceRepository));
            profilerCommandLocatorBuilder.addService(new GrpcActiveThreadDumpService(activeTraceRepository, this.threadDumpMapper));
            profilerCommandLocatorBuilder.addService(new GrpcActiveThreadLightDumpService(activeTraceRepository, this.threadDumpMapper));
        }
        ProfilerCommandServiceLocator commandServiceLocator = profilerCommandLocatorBuilder.build();
        return commandServiceLocator;
    }
}

