/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.common.profiler.clock.Clock;
import com.navercorp.pinpoint.common.profiler.clock.TickClock;
import com.navercorp.pinpoint.common.profiler.concurrent.executor.AsyncQueueingExecutor;
import com.navercorp.pinpoint.common.profiler.concurrent.executor.MultiConsumer;
import com.navercorp.pinpoint.common.profiler.logging.ThrottledLogger;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.storage.Snapshot;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatInfo;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncQueueingUriStatStorage
extends AsyncQueueingExecutor<UriStatInfo>
implements UriStatStorage {
    private static final Logger LOGGER = LogManager.getLogger(AsyncQueueingUriStatStorage.class);
    private static final ThrottledLogger TLogger = ThrottledLogger.getLogger((Logger)LOGGER, (long)100L);
    private final UriStatConsumer consumer;
    private final boolean uriStatCollectHttpMethod;

    public AsyncQueueingUriStatStorage(boolean uriStatCollectHttpMethod, int queueSize, int uriStatDataLimitSize, String executorName) {
        this(uriStatCollectHttpMethod, queueSize, executorName, new UriStatConsumer(uriStatDataLimitSize));
    }

    public AsyncQueueingUriStatStorage(boolean uriStatCollectHttpMethod, int queueSize, int uriStatDataLimitSize, String executorName, int collectInterval) {
        this(uriStatCollectHttpMethod, queueSize, executorName, new UriStatConsumer(uriStatDataLimitSize, collectInterval));
    }

    private AsyncQueueingUriStatStorage(boolean uriStatCollectHttpMethod, int queueSize, String executorName, UriStatConsumer consumer) {
        super(queueSize, executorName, (MultiConsumer)consumer);
        this.consumer = consumer;
        this.uriStatCollectHttpMethod = uriStatCollectHttpMethod;
    }

    @Override
    public void store(String uri, String httpMethod, boolean status, long startTime, long endTime) {
        if (uri == null) {
            uri = "/NULL";
        }
        if (this.uriStatCollectHttpMethod && httpMethod != null && !httpMethod.isEmpty()) {
            uri = httpMethod + " " + uri;
        }
        UriStatInfo uriStatInfo = new UriStatInfo(uri, status, startTime, endTime);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("UriStatInfo {}", (Object)uriStatInfo);
        }
        this.execute(uriStatInfo);
    }

    @Override
    public AgentUriStatData poll() {
        return this.consumer.pollCompletedData();
    }

    @Override
    public void close() {
        this.stop();
    }

    protected void pollTimeout(long timeout) {
        this.consumer.executePollTimeout();
    }

    static class UriStatConsumer
    implements MultiConsumer<UriStatInfo> {
        private static final int DEFAULT_COLLECT_INTERVAL = 30000;
        private static final int SNAPSHOT_LIMIT = 4;
        private final TickClock clock;
        private final Queue<AgentUriStatData> snapshotQueue;
        private final Snapshot<AgentUriStatData> snapshotManager;

        public UriStatConsumer(int uriStatDataLimitSize) {
            this(uriStatDataLimitSize, 30000);
        }

        public UriStatConsumer(int uriStatDataLimitSize, int collectInterval) {
            Assert.isTrue((uriStatDataLimitSize > 0 ? 1 : 0) != 0, (String)"uriStatDataLimitSize must be ' > 0'");
            Assert.isTrue((collectInterval > 0 ? 1 : 0) != 0, (String)"collectInterval must be ' > 0'");
            this.clock = (TickClock)Clock.tick((long)collectInterval);
            this.snapshotQueue = new ConcurrentLinkedQueue<AgentUriStatData>();
            this.snapshotManager = new Snapshot<AgentUriStatData>(value -> new AgentUriStatData(value, uriStatDataLimitSize, this.clock), AgentUriStatData::getBaseTimestamp);
        }

        public void acceptN(Collection<UriStatInfo> messageList) {
            long currentBaseTimestamp = this.clock.millis();
            this.checkAndFlushOldData(currentBaseTimestamp);
            AgentUriStatData agentUriStatData = this.snapshotManager.getCurrent(currentBaseTimestamp);
            Object[] dataList = messageList.toArray();
            for (int i = 0; i < CollectionUtils.nullSafeSize(messageList); ++i) {
                this.addUriData(agentUriStatData, (UriStatInfo)dataList[i]);
            }
        }

        public void accept(UriStatInfo message) {
            long currentBaseTimestamp = this.clock.millis();
            this.checkAndFlushOldData(currentBaseTimestamp);
            AgentUriStatData agentUriStatData = this.snapshotManager.getCurrent(currentBaseTimestamp);
            this.addUriData(agentUriStatData, message);
        }

        private void addUriData(AgentUriStatData agentUriStatData, UriStatInfo uriStatInfo) {
            if (!agentUriStatData.add(uriStatInfo)) {
                TLogger.info("Too many URI pattern. sample-message:{}, capacity:{}, counter:{} ", new Object[]{uriStatInfo, agentUriStatData.getCapacity(), TLogger.getCounter()});
            }
        }

        public void executePollTimeout() {
            long currentBaseTimestamp = this.clock.millis();
            boolean flush = this.checkAndFlushOldData(currentBaseTimestamp);
            if (flush) {
                LOGGER.debug("checkAndFlushOldData {}", (Object)flush);
            }
        }

        private boolean checkAndFlushOldData(long currentBaseTimestamp) {
            AgentUriStatData snapshot = this.snapshotManager.takeSnapshot(currentBaseTimestamp);
            if (snapshot != null) {
                this.addCompletedData(snapshot);
                return true;
            }
            return false;
        }

        private void addCompletedData(AgentUriStatData agentUriStatData) {
            int size = this.snapshotQueue.size();
            if (size > 4) {
                this.drainN(size - 4);
            }
            this.snapshotQueue.offer(agentUriStatData);
        }

        private void drainN(int drainSize) {
            for (int i = 0; i < drainSize; ++i) {
                this.snapshotQueue.poll();
            }
        }

        private AgentUriStatData pollCompletedData() {
            return this.snapshotQueue.poll();
        }
    }
}

