/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.uri;

import com.navercorp.pinpoint.common.profiler.clock.TickClock;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.EachUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.URIKey;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentUriStatData
implements MetricType {
    private static final Logger LOGGER = LogManager.getLogger(AgentUriStatData.class);
    private final int capacity;
    private final long baseTimestamp;
    private final TickClock clock;
    private final Map<URIKey, EachUriStatData> eachUriStatDataMap = new HashMap<URIKey, EachUriStatData>();

    public AgentUriStatData(long baseTimestamp, int capacity, TickClock clock) {
        this.clock = Objects.requireNonNull(clock, "clock");
        Assert.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"capacity must be  ` > 0`");
        this.capacity = capacity;
        Assert.isTrue((baseTimestamp > 0L ? 1 : 0) != 0, (String)"baseTimestamp must be  ` > 0`");
        this.baseTimestamp = baseTimestamp;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getBaseTimestamp() {
        return this.baseTimestamp;
    }

    public boolean add(UriStatInfo uriStatInfo) {
        if (this.eachUriStatDataMap.size() >= this.capacity) {
            return false;
        }
        if (uriStatInfo.getEndTime() == 0L) {
            LOGGER.info("Cannot add collected uri stat info: endTime is 0 for {}", (Object)uriStatInfo.getUri());
            return true;
        }
        URIKey key = this.newURIKey(uriStatInfo);
        EachUriStatData eachUriStatData = this.eachUriStatDataMap.get(key);
        if (eachUriStatData == null) {
            eachUriStatData = new EachUriStatData(key.getUri());
            this.eachUriStatDataMap.put(key, eachUriStatData);
        }
        eachUriStatData.add(uriStatInfo);
        return true;
    }

    private URIKey newURIKey(UriStatInfo uriStatInfo) {
        String uri = uriStatInfo.getUri();
        long tickTime = this.clock.tick(uriStatInfo.getEndTime());
        return new URIKey(uri, tickTime);
    }

    public Set<Map.Entry<URIKey, EachUriStatData>> getAllUriStatData() {
        return this.eachUriStatDataMap.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AgentUriStatData{");
        sb.append("baseTimestamp=").append(this.baseTimestamp);
        sb.append(", eachUriStatDataMap=").append(this.eachUriStatDataMap);
        sb.append('}');
        return sb.toString();
    }
}

