/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.uri;

import com.navercorp.pinpoint.common.trace.UriStatHistogramBucket;
import java.util.Arrays;
import java.util.Objects;

public class UriStatHistogram {
    private final UriStatHistogramBucket.Layout layout;
    private int count = 0;
    private long total = 0L;
    private long max = 0L;
    private final int[] timestampHistogram;

    public UriStatHistogram() {
        this(UriStatHistogramBucket.getLayout());
    }

    UriStatHistogram(UriStatHistogramBucket.Layout layout) {
        this.layout = Objects.requireNonNull(layout, "layout");
        this.timestampHistogram = new int[layout.getBucketSize()];
    }

    public void add(long elapsed) {
        ++this.count;
        this.total += elapsed;
        this.max = Math.max(this.max, elapsed);
        UriStatHistogramBucket bucket = this.layout.getBucket(elapsed);
        int n = bucket.getIndex();
        this.timestampHistogram[n] = this.timestampHistogram[n] + 1;
    }

    private boolean isEmpty() {
        return this.count == 0;
    }

    public int getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public long getMax() {
        return this.max;
    }

    public int[] getTimestampHistogram() {
        return this.timestampHistogram;
    }

    public byte getBucketVersion() {
        return this.layout.getBucketVersion();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UriStatHistogram{");
        sb.append("count=").append(this.count);
        sb.append(", total=").append(this.total);
        sb.append(", max=").append(this.max);
        sb.append(", timestampHistogram=").append(Arrays.toString(this.timestampHistogram));
        sb.append('}');
        return sb.toString();
    }
}

