/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import com.navercorp.pinpoint.profiler.plugin.JarPlugin;
import com.navercorp.pinpoint.profiler.plugin.Plugin;
import com.navercorp.pinpoint.profiler.plugin.PluginException;
import java.net.URL;
import java.util.Objects;
import java.util.jar.JarFile;

public class PluginConfig {
    private final JarPlugin<?> plugin;
    private final ClassNameFilter pluginPackageFilter;
    private final ClassNameFilter pluginPackageRequirementFilter;
    private String pluginJarURLExternalForm;

    public PluginConfig(Plugin<?> plugin, ClassNameFilter pluginPackageFilter, ClassNameFilter pluginPackageRequirementFilter) {
        this.plugin = this.cast(plugin);
        this.pluginPackageFilter = pluginPackageFilter;
        this.pluginPackageRequirementFilter = pluginPackageRequirementFilter;
    }

    private JarPlugin<?> cast(Plugin<?> plugin) {
        Objects.requireNonNull(plugin, "plugin");
        if (plugin instanceof JarPlugin) {
            return (JarPlugin)plugin;
        }
        throw new PluginException("unsupported plugin " + plugin);
    }

    public URL getPluginURL() {
        return this.plugin.getURL();
    }

    public JarFile getPluginJarFile() {
        return this.plugin.getJarFile();
    }

    public String getPluginJarURLExternalForm() {
        if (this.pluginJarURLExternalForm == null) {
            this.pluginJarURLExternalForm = this.plugin.getURL().toExternalForm();
        }
        return this.pluginJarURLExternalForm;
    }

    public ClassNameFilter getPluginPackageFilter() {
        return this.pluginPackageFilter;
    }

    public ClassNameFilter getPluginPackageRequirementFilter() {
        return this.pluginPackageRequirementFilter;
    }

    public String toString() {
        return "PluginConfig{pluginJar=" + this.pluginJarURLExternalForm + ", pluginPackageFilter=" + this.pluginPackageFilter + '}';
    }
}

