/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin.filter;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.plugin.filter.ImportPluginFilter;
import com.navercorp.pinpoint.profiler.plugin.filter.JavaVersionFilter;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilter;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilterFactory;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilters;
import java.util.List;
import java.util.Objects;

public class ImportPluginFilterFactory
implements PluginFilterFactory {
    private final List<String> importPluginIds;

    public ImportPluginFilterFactory(List<String> importPluginIds) {
        Objects.requireNonNull(importPluginIds, "importPluginIds");
        this.importPluginIds = importPluginIds;
    }

    @Override
    public PluginFilter newPluginFilter() {
        if (CollectionUtils.isEmpty(this.importPluginIds)) {
            return new JavaVersionFilter();
        }
        JavaVersionFilter javaVersionFilter = new JavaVersionFilter();
        ImportPluginFilter enablePluginFilter = new ImportPluginFilter(this.importPluginIds);
        return new PluginFilters(enablePluginFilter, javaVersionFilter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EnablePluginJarFilterFactory{");
        sb.append("importPluginIds=").append(this.importPluginIds);
        sb.append('}');
        return sb.toString();
    }
}

