/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.common.util.ThreadMXBeanUtils;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.MonitorInfoMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.Collections;
import java.util.Objects;

public class ThreadDumpUtils {
    public static ThreadDumpMetricSnapshot createThreadDump(Thread thread) {
        Objects.requireNonNull(thread, "thread");
        ThreadInfo threadInfo = ThreadMXBeanUtils.getThreadInfo((long)thread.getId());
        if (threadInfo == null) {
            return null;
        }
        return ThreadDumpUtils.createThreadDump(threadInfo);
    }

    public static ThreadDumpMetricSnapshot createThreadDump(Thread thread, int stackTraceMaxDepth) {
        Objects.requireNonNull(thread, "thread");
        ThreadInfo threadInfo = ThreadMXBeanUtils.getThreadInfo((long)thread.getId(), (int)stackTraceMaxDepth);
        if (threadInfo == null) {
            return null;
        }
        return ThreadDumpUtils.createThreadDump(threadInfo);
    }

    public static ThreadDumpMetricSnapshot createThreadDump(ThreadInfo threadInfo) {
        ThreadDumpMetricSnapshot threadDump = new ThreadDumpMetricSnapshot();
        ThreadDumpUtils.setThreadInfo(threadDump, threadInfo);
        ThreadDumpUtils.setThreadStatus(threadDump, threadInfo);
        ThreadDumpUtils.setStackTrace(threadDump, threadInfo);
        ThreadDumpUtils.setMonitorInfo(threadDump, threadInfo);
        ThreadDumpUtils.setLockInfo(threadDump, threadInfo);
        return threadDump;
    }

    public static ThreadDumpMetricSnapshot createTThreadDump(long threadId) {
        ThreadInfo threadInfo = ThreadMXBeanUtils.getThreadInfo((long)threadId);
        if (threadInfo == null) {
            return null;
        }
        return ThreadDumpUtils.createThreadDump(threadInfo);
    }

    private static void setThreadInfo(ThreadDumpMetricSnapshot threadDump, ThreadInfo threadInfo) {
        threadDump.setThreadName(threadInfo.getThreadName());
        threadDump.setThreadId(threadInfo.getThreadId());
        threadDump.setBlockedTime(threadInfo.getBlockedTime());
        threadDump.setBlockedCount(threadInfo.getBlockedCount());
        threadDump.setWaitedTime(threadInfo.getWaitedTime());
        threadDump.setWaitedCount(threadInfo.getWaitedCount());
    }

    private static void setThreadStatus(ThreadDumpMetricSnapshot threadDump, ThreadInfo threadInfo) {
        threadDump.setInNative(threadInfo.isInNative());
        threadDump.setSuspended(threadInfo.isSuspended());
        threadDump.setThreadState(threadInfo.getThreadState());
    }

    private static void setStackTrace(ThreadDumpMetricSnapshot threadDump, ThreadInfo threadInfo) {
        StackTraceElement[] stackTraceElements = threadInfo.getStackTrace();
        if (stackTraceElements != null) {
            for (StackTraceElement element : stackTraceElements) {
                if (element == null) continue;
                threadDump.addStackTrace(element.toString());
            }
        } else {
            threadDump.setStackTrace(Collections.emptyList());
        }
    }

    private static void setMonitorInfo(ThreadDumpMetricSnapshot threadDump, ThreadInfo threadInfo) {
        MonitorInfo[] monitorInfos = threadInfo.getLockedMonitors();
        if (monitorInfos != null) {
            for (MonitorInfo each : monitorInfos) {
                if (each == null) continue;
                MonitorInfoMetricSnapshot monitorInfoMetricSnapshot = new MonitorInfoMetricSnapshot();
                monitorInfoMetricSnapshot.setStackDepth(each.getLockedStackDepth());
                monitorInfoMetricSnapshot.setStackFrame(each.getLockedStackFrame().toString());
                threadDump.addLockedMonitor(monitorInfoMetricSnapshot);
            }
        } else {
            threadDump.setLockedMonitors(Collections.emptyList());
        }
    }

    private static void setLockInfo(ThreadDumpMetricSnapshot threadDump, ThreadInfo threadInfo) {
        threadDump.setLockName(threadInfo.getLockName());
        threadDump.setLockOwnerId(threadInfo.getLockOwnerId());
        threadDump.setLockOwnerName(threadInfo.getLockOwnerName());
        LockInfo[] lockInfos = threadInfo.getLockedSynchronizers();
        if (lockInfos != null) {
            for (LockInfo lockInfo : lockInfos) {
                if (lockInfo == null) continue;
                threadDump.addLockedSynchronizer(lockInfo.toString());
            }
        } else {
            threadDump.setLockedSynchronizers(Collections.emptyList());
        }
    }
}

