/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util.queue;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectArrayIterator<E>
implements Iterator<E> {
    private final E[] array;
    private final int endIndex;
    private int index = 0;

    public ObjectArrayIterator(E[] array) {
        this(array, array.length);
    }

    public ObjectArrayIterator(E[] array, int end) {
        if (end > array.length) {
            throw new ArrayIndexOutOfBoundsException("End index must not be greater than the array length");
        }
        this.array = array;
        this.endIndex = end;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.index++];
    }
}

