/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.logging;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;

public class LogSampler {
    private final long ratio;
    private final AtomicLong counter = new AtomicLong();

    public LogSampler(long ratio) {
        this.ratio = ratio;
    }

    private boolean isSampled(long counter) {
        return counter % this.ratio == 0L;
    }

    public void log(LongConsumer log) {
        long counter = this.counter.getAndIncrement();
        if (this.isSampled(counter)) {
            log.accept(counter);
        }
    }

    public void log(Runnable log) {
        long counter = this.counter.getAndIncrement();
        if (this.isSampled(counter)) {
            log.run();
        }
    }
}

