/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigInfo;
import org.apache.eventmesh.common.config.ConfigMonitorService;
import org.apache.eventmesh.common.config.FileLoad;
import org.apache.eventmesh.common.utils.ReflectUtils;
import org.assertj.core.util.Strings;

public class ConfigService {
    private static final ConfigService INSTANCE = new ConfigService();
    public static final String CLASS_PATH_PREFIX = "classPath://";
    public static final String FILE_PATH_PREFIX = "file://";
    private Properties properties = new Properties();
    private String rootPath;
    private static final ConfigMonitorService configMonitorService = new ConfigMonitorService();
    private String configPath;

    public static ConfigService getInstance() {
        return INSTANCE;
    }

    private ConfigService() {
    }

    public ConfigService setConfigPath(String configPath) {
        if (StringUtils.isNotBlank((CharSequence)configPath) && !configPath.endsWith(File.separator)) {
            configPath = configPath + File.separator;
        }
        this.configPath = configPath;
        return this;
    }

    public void setRootConfig(String path) throws Exception {
        ConfigInfo configInfo = new ConfigInfo();
        this.rootPath = path;
        configInfo.setPath(this.rootPath);
        this.properties = (Properties)this.getConfig(configInfo);
    }

    public Properties getRootConfig() {
        return this.properties;
    }

    public <T> T buildConfigInstance(Class<?> clazz) {
        Config[] configArray = (Config[])clazz.getAnnotationsByType(Config.class);
        Config config = configArray.length == 0 ? null : configArray[0];
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setClazz(clazz);
        configInfo.setPath(config == null ? null : config.path());
        configInfo.setHump(config == null ? "spot" : config.hump());
        configInfo.setPrefix(config == null ? null : config.prefix());
        configInfo.setMonitor(config != null && config.monitor());
        configInfo.setReloadMethodName(config == null ? null : config.reloadMethodName());
        try {
            return this.getConfig(configInfo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void populateConfigForObject(Object object) throws IllegalAccessException, NoSuchFieldException, IOException {
        Class<?> clazz = object.getClass();
        Config[] configArray = (Config[])clazz.getAnnotationsByType(Config.class);
        if (configArray.length == 0) {
            return;
        }
        for (Config config : configArray) {
            this.populateConfig(object, clazz, config);
        }
    }

    public <T> T getConfig(ConfigInfo configInfo) throws IOException {
        String filePath;
        String resourceUrl;
        String path;
        block13: {
            path = configInfo.getPath();
            if (StringUtils.isBlank((CharSequence)path)) {
                Object object = FileLoad.getPropertiesFileLoad().getConfig(this.properties, configInfo);
                return object;
            }
            resourceUrl = null;
            if (path.startsWith(CLASS_PATH_PREFIX)) {
                resourceUrl = "/" + path.substring(CLASS_PATH_PREFIX.length());
                URL fileURL = this.getClass().getResource(resourceUrl);
                if (fileURL == null) {
                    throw new RuntimeException("file is not exists");
                }
                filePath = fileURL.getPath();
            } else {
                filePath = path.startsWith(FILE_PATH_PREFIX) ? path.substring(FILE_PATH_PREFIX.length()) : this.configPath + path;
            }
            filePath = this.normalizeFilePath(filePath);
            if (filePath.contains(".jar")) {
                try (InputStream inputStream = this.getClass().getResourceAsStream(Objects.requireNonNull(resourceUrl));){
                    if (inputStream == null) {
                        throw new RuntimeException("file is not exists");
                    }
                    break block13;
                }
            }
            File file = new File(filePath);
            if (!file.exists()) {
                throw new RuntimeException("file is not exists");
            }
        }
        String suffix = path.substring(path.lastIndexOf(46) + 1);
        configInfo.setFilePath(filePath);
        configInfo.setResourceUrl(resourceUrl);
        Object object = FileLoad.getFileLoad(suffix).getConfig(configInfo);
        return object;
    }

    private String normalizeFilePath(String filePath) {
        if (System.getProperty("os.name").toLowerCase().contains("win") && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateConfig(Object object, Class<?> clazz, Config config) throws NoSuchFieldException, IOException, IllegalAccessException {
        Field field;
        ConfigInfo configInfo;
        block7: {
            configInfo = new ConfigInfo();
            configInfo.setField(config.field());
            configInfo.setMonitor(config.monitor());
            configInfo.setReloadMethodName(config.reloadMethodName());
            field = null;
            try {
                field = clazz.getDeclaredField(configInfo.getField());
            }
            catch (NoSuchFieldException e) {
                field = ReflectUtils.lookUpFieldByParentClass(clazz, configInfo.getField());
                if (field != null) break block7;
                throw e;
            }
        }
        configInfo.setClazz(field.getType());
        Config configType = field.getType().getAnnotation(Config.class);
        if (configType != null && !Strings.isNullOrEmpty((String)configType.prefix())) {
            configInfo.setPrefix(configType.prefix());
            configInfo.setPath(configType.path());
            configInfo.setHump(configType.hump());
        }
        Object configObject = this.getConfig(configInfo);
        try {
            field.setAccessible(true);
            field.set(object, configObject);
        }
        finally {
            field.setAccessible(false);
        }
        if (configInfo.isMonitor()) {
            configInfo.setObjectField(field);
            configInfo.setInstance(object);
            configInfo.setObject(configObject);
            configMonitorService.monitor(configInfo);
        }
    }

    @Generated
    public String getRootPath() {
        return this.rootPath;
    }
}

