/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog;

import com.taobao.tddl.dbsync.binlog.LogFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DirectLogFetcher
extends LogFetcher {
    protected static final Log logger = LogFactory.getLog(DirectLogFetcher.class);
    public static final byte COM_BINLOG_DUMP = 18;
    public static final int NET_HEADER_SIZE = 4;
    public static final int SQLSTATE_LENGTH = 5;
    public static final int PACKET_LEN_OFFSET = 0;
    public static final int PACKET_SEQ_OFFSET = 3;
    public static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    public static final int BINLOG_DUMP_NON_BLOCK = 1;
    public static final int BINLOG_SEND_ANNOTATE_ROWS_EVENT = 2;
    private Connection conn;
    private OutputStream mysqlOutput;
    private InputStream mysqlInput;

    public DirectLogFetcher() {
        super(8192, 2.0f);
    }

    public DirectLogFetcher(int initialCapacity) {
        super(initialCapacity, 2.0f);
    }

    public DirectLogFetcher(int initialCapacity, float growthFactor) {
        super(initialCapacity, growthFactor);
    }

    private static final Object unwrapConnection(Object conn, Class<?> connClazz) throws IOException {
        while (!connClazz.isInstance(conn)) {
            Class<?> connProxy2;
            try {
                connProxy2 = Class.forName("org.springframework.jdbc.datasource.ConnectionProxy");
                if (connProxy2.isInstance(conn)) {
                    conn = DirectLogFetcher.invokeMethod(conn, connProxy2, "getTargetConnection");
                    continue;
                }
            }
            catch (ClassNotFoundException connProxy2) {
                // empty catch block
            }
            try {
                connProxy2 = Class.forName("org.apache.commons.dbcp.DelegatingConnection");
                if (connProxy2.isInstance(conn)) {
                    conn = DirectLogFetcher.getDeclaredField(conn, connProxy2, "_conn");
                    continue;
                }
            }
            catch (ClassNotFoundException connProxy3) {
                // empty catch block
            }
            try {
                if (conn instanceof Wrapper) {
                    Class<?> connIface = Class.forName("com.mysql.jdbc.Connection");
                    conn = ((Wrapper)conn).unwrap(connIface);
                    continue;
                }
            }
            catch (ClassNotFoundException connIface) {
            }
            catch (SQLException e) {
                logger.warn((Object)("Unwrap " + conn.getClass().getName() + " to " + connClazz.getName() + " failed: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
        return conn;
    }

    private static final Object invokeMethod(Object obj, Class<?> objClazz, String name) {
        try {
            Method method = objClazz.getMethod(name, null);
            return method.invoke(obj, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No such method: '" + name + "' @ " + objClazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot invoke method: '" + name + "' @ " + objClazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Invoke method failed: '" + name + "' @ " + objClazz.getName(), e.getTargetException());
        }
    }

    private static final Object getDeclaredField(Object obj, Class<?> objClazz, String name) {
        try {
            Field field = objClazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("No such field: '" + name + "' @ " + objClazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot get field: '" + name + "' @ " + objClazz.getName(), e);
        }
    }

    public void open(Connection conn, String fileName, int serverId) throws IOException {
        this.open(conn, fileName, 4L, serverId, false);
    }

    public void open(Connection conn, String fileName, int serverId, boolean nonBlocking) throws IOException {
        this.open(conn, fileName, 4L, serverId, nonBlocking);
    }

    public void open(Connection conn, String fileName, long filePosition, int serverId) throws IOException {
        this.open(conn, fileName, filePosition, serverId, false);
    }

    public void open(Connection conn, String fileName, long filePosition, int serverId, boolean nonBlocking) throws IOException {
        try {
            this.conn = conn;
            Class<?> connClazz = Class.forName("com.mysql.jdbc.ConnectionImpl");
            Object unwrapConn = DirectLogFetcher.unwrapConnection(conn, connClazz);
            if (unwrapConn == null) {
                throw new IOException("Unable to unwrap " + conn.getClass().getName() + " to com.mysql.jdbc.ConnectionImpl");
            }
            Object connIo = DirectLogFetcher.getDeclaredField(unwrapConn, connClazz, "io");
            if (connIo == null) {
                throw new IOException("Get null field:" + conn.getClass().getName() + "#io");
            }
            this.mysqlOutput = (OutputStream)DirectLogFetcher.getDeclaredField(connIo, connIo.getClass(), "mysqlOutput");
            this.mysqlInput = (InputStream)DirectLogFetcher.getDeclaredField(connIo, connIo.getClass(), "mysqlInput");
            if (filePosition == 0L) {
                filePosition = 4L;
            }
            this.sendBinlogDump(fileName, filePosition, serverId, nonBlocking);
            this.position = 0;
        }
        catch (IOException e) {
            this.close();
            logger.error((Object)("Error on COM_BINLOG_DUMP: file = " + fileName + ", position = " + filePosition));
            throw e;
        }
        catch (ClassNotFoundException e) {
            this.close();
            throw new IOException("Unable to load com.mysql.jdbc.ConnectionImpl", e);
        }
    }

    protected final void putByte(byte b) {
        this.ensureCapacity(this.position + 1);
        this.buffer[this.position++] = b;
    }

    protected final void putInt16(int i16) {
        this.ensureCapacity(this.position + 2);
        byte[] buf = this.buffer;
        buf[this.position++] = (byte)(i16 & 0xFF);
        buf[this.position++] = (byte)(i16 >>> 8);
    }

    protected final void putInt32(long i32) {
        this.ensureCapacity(this.position + 4);
        byte[] buf = this.buffer;
        buf[this.position++] = (byte)(i32 & 0xFFL);
        buf[this.position++] = (byte)(i32 >>> 8);
        buf[this.position++] = (byte)(i32 >>> 16);
        buf[this.position++] = (byte)(i32 >>> 24);
    }

    protected final void putString(String s) {
        this.ensureCapacity(this.position + s.length() * 2 + 1);
        System.arraycopy(s.getBytes(), 0, this.buffer, this.position, s.length());
        this.position += s.length();
        this.buffer[this.position++] = 0;
    }

    protected final void sendBinlogDump(String fileName, long filePosition, int serverId, boolean nonBlocking) throws IOException {
        this.position = 4;
        this.putByte((byte)18);
        this.putInt32(filePosition);
        int binlog_flags = nonBlocking ? 1 : 0;
        this.putInt16(binlog_flags |= 2);
        this.putInt32(serverId);
        this.putString(fileName);
        byte[] buf = this.buffer;
        int len = this.position - 4;
        buf[0] = (byte)(len & 0xFF);
        buf[1] = (byte)(len >>> 8);
        buf[2] = (byte)(len >>> 16);
        this.mysqlOutput.write(this.buffer, 0, this.position);
        this.mysqlOutput.flush();
    }

    @Override
    public boolean fetch() throws IOException {
        try {
            if (!this.fetch0(0, 4)) {
                logger.warn((Object)"Reached end of input stream while fetching header");
                return false;
            }
            int netlen = this.getUint24(0);
            int netnum = this.getUint8(3);
            if (!this.fetch0(4, netlen)) {
                logger.warn((Object)("Reached end of input stream: packet #" + netnum + ", len = " + netlen));
                return false;
            }
            int mark = this.getUint8(4);
            if (mark != 0) {
                if (mark == 255) {
                    this.position = 5;
                    int errno = this.getInt16();
                    String sqlstate = this.forward(1).getFixString(5);
                    String errmsg = this.getFixString(this.limit - this.position);
                    throw new IOException("Received error packet: errno = " + errno + ", sqlstate = " + sqlstate + " errmsg = " + errmsg);
                }
                if (mark == 254) {
                    logger.warn((Object)"Received EOF packet from server, apparent master disconnected.");
                    return false;
                }
                throw new IOException("Unexpected response " + mark + " while fetching binlog: packet #" + netnum + ", len = " + netlen);
            }
            while (netlen == 0xFFFFFF) {
                if (!this.fetch0(0, 4)) {
                    logger.warn((Object)"Reached end of input stream while fetching header");
                    return false;
                }
                netlen = this.getUint24(0);
                netnum = this.getUint8(3);
                if (this.fetch0(this.limit, netlen)) continue;
                logger.warn((Object)("Reached end of input stream: packet #" + netnum + ", len = " + netlen));
                return false;
            }
            this.position = this.origin = 5;
            this.limit -= this.origin;
            return true;
        }
        catch (SocketTimeoutException e) {
            this.close();
            logger.error((Object)"Socket timeout expired, closing connection", (Throwable)e);
            throw e;
        }
        catch (InterruptedIOException e) {
            this.close();
            logger.warn((Object)"I/O interrupted while reading from client socket", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.close();
            logger.error((Object)"I/O error while reading from client socket", (Throwable)e);
            throw e;
        }
    }

    private final boolean fetch0(int off, int len) throws IOException {
        int count;
        this.ensureCapacity(off + len);
        for (int n = 0; n < len; n += count) {
            count = this.mysqlInput.read(this.buffer, off + n, len - n);
            if (0 <= count) continue;
            return false;
        }
        if (this.limit < off + len) {
            this.limit = off + len;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
            this.conn = null;
            this.mysqlInput = null;
            this.mysqlOutput = null;
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to close connection", (Throwable)e);
        }
    }
}

