/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.opentelemetry.api.trace.Span;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.eventmesh.common.Pair;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.protocol.tcp.codec.Codec;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.boot.TCPThreadPoolGroup;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMetricsManager;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTCPServer
extends AbstractRemotingServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTCPServer.class);
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private final EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private ClientSessionGroupMapping clientSessionGroupMapping;
    protected EventMeshTcpMetricsManager eventMeshTcpMetricsManager;
    private transient GlobalTrafficShapingHandler globalTrafficShapingHandler;
    private TcpConnectionHandler tcpConnectionHandler;
    private TcpDispatcher tcpDispatcher;
    private final Map<Command, Pair<TcpProcessor, ThreadPoolExecutor>> tcpRequestProcessorTable = new ConcurrentHashMap<Command, Pair<TcpProcessor, ThreadPoolExecutor>>(64);
    private final transient AtomicBoolean started = new AtomicBoolean(false);
    private final TCPThreadPoolGroup tcpThreadPoolGroup;

    public AbstractTCPServer(EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
        this.tcpThreadPoolGroup = new TCPThreadPoolGroup(eventMeshTCPConfiguration);
    }

    private void initSharableHandlers() {
        this.tcpConnectionHandler = new TcpConnectionHandler();
        this.tcpDispatcher = new TcpDispatcher();
    }

    @Override
    public void init() throws Exception {
        super.init("eventMesh-tcp");
        this.initProducerManager();
        this.tcpThreadPoolGroup.initThreadPool();
    }

    @Override
    public CommonConfiguration getConfiguration() {
        return this.eventMeshTCPConfiguration;
    }

    @Override
    public void start() throws Exception {
        this.initSharableHandlers();
        Thread thread = new Thread(() -> {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.getBossGroup(), this.getIoGroup()).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.SO_LINGER, (Object)0).childOption(ChannelOption.SO_TIMEOUT, (Object)600000).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)262140).childOption(ChannelOption.SO_RCVBUF, (Object)262140).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(2048, 4096, 65536))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new TcpServerInitializer());
            try {
                int port = this.eventMeshTCPConfiguration.getEventMeshTcpServerPort();
                ChannelFuture f = bootstrap.bind(port).sync();
                log.info("EventMeshTCPServer[port={}] started.....", (Object)port);
                f.channel().closeFuture().sync();
            }
            catch (Exception e) {
                log.error("EventMeshTCPServer RemotingServer Start Err!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception ex) {
                    log.error("EventMeshTCPServer RemotingServer shutdown Err!", (Throwable)ex);
                }
                System.exit(-1);
            }
        }, "eventMesh-tcp-server");
        thread.start();
        this.started.compareAndSet(false, true);
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.tcpThreadPoolGroup.shutdownThreadPool();
        this.globalTrafficShapingHandler.release();
        this.started.compareAndSet(true, false);
    }

    public void registerProcessor(Command command, TcpProcessor processor, ThreadPoolExecutor executor) {
        AssertUtils.notNull((Object)command, (String)"command can't be null");
        AssertUtils.notNull((Object)processor, (String)"processor can't be null");
        AssertUtils.notNull((Object)executor, (String)"executor can't be null");
        this.tcpRequestProcessorTable.put(command, (Pair<TcpProcessor, ThreadPoolExecutor>)new Pair((Object)processor, (Object)executor));
    }

    public TcpConnectionHandler getTcpConnectionHandler() {
        return this.tcpConnectionHandler;
    }

    public EventMeshTcpMetricsManager getEventMeshTcpMetricsManager() {
        return this.eventMeshTcpMetricsManager;
    }

    public void setEventMeshTcpMetricsManager(EventMeshTcpMetricsManager eventMeshTcpMetricsManager) {
        this.eventMeshTcpMetricsManager = eventMeshTcpMetricsManager;
    }

    public TcpDispatcher getTcpDispatcher() {
        return this.tcpDispatcher;
    }

    public void setTcpDispatcher(TcpDispatcher tcpDispatcher) {
        this.tcpDispatcher = tcpDispatcher;
    }

    public TCPThreadPoolGroup getTcpThreadPoolGroup() {
        return this.tcpThreadPoolGroup;
    }

    public ClientSessionGroupMapping getClientSessionGroupMapping() {
        return this.clientSessionGroupMapping;
    }

    public void setClientSessionGroupMapping(ClientSessionGroupMapping clientSessionGroupMapping) {
        this.clientSessionGroupMapping = clientSessionGroupMapping;
    }

    @ChannelHandler.Sharable
    public class TcpConnectionHandler
    extends ChannelDuplexHandler {
        private final AtomicInteger connections = new AtomicInteger(0);

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("client|tcp|channelRegistered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
            super.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("client|tcp|channelUnregistered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
            super.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("client|tcp|channelActive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
            if (this.connections.incrementAndGet() > AbstractTCPServer.this.eventMeshTCPConfiguration.getEventMeshTcpClientMaxNum()) {
                log.warn("client|tcp|channelActive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"too many client connect this eventMesh server");
                ctx.close();
                return;
            }
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.connections.decrementAndGet();
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("client|tcp|channelInactive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
            AbstractTCPServer.this.clientSessionGroupMapping.closeSession(ctx);
            super.channelInactive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.info("client|tcp|userEventTriggered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)evt.getClass().getName());
                AbstractTCPServer.this.clientSessionGroupMapping.closeSession(ctx);
            }
            ctx.fireUserEventTriggered(evt);
        }

        public int getConnectionCount() {
            return this.connections.get();
        }
    }

    @ChannelHandler.Sharable
    private class TcpDispatcher
    extends SimpleChannelInboundHandler<Package> {
        private TcpDispatcher() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, Package pkg) throws Exception {
            long startTime = System.currentTimeMillis();
            this.validateMsg(pkg);
            AbstractTCPServer.this.eventMeshTcpMetricsManager.client2eventMeshMsgNumIncrement(IPUtils.parseChannelRemoteAddr((Channel)ctx.channel()));
            Command cmd = pkg.getHeader().getCmd();
            try {
                if (this.isNeedTrace(cmd)) {
                    pkg.getHeader().getProperties().put("reqc2eventmeshtimestamp", startTime);
                    pkg.getHeader().getProperties().put("reqsendeventmeship", AbstractTCPServer.this.eventMeshTCPConfiguration.getEventMeshServerIp());
                    Session session = AbstractTCPServer.this.clientSessionGroupMapping.getSession(ctx);
                    pkg.getHeader().getProperties().put("req0sys", session.getClient().getSubsystem());
                    pkg.getHeader().getProperties().put("req0ip", session.getClient().getHost());
                    pkg.getHeader().getProperties().put("req0idc", session.getClient().getIdc());
                    pkg.getHeader().getProperties().put("req0group", session.getClient().getGroup());
                }
                if (Command.HELLO_REQUEST == cmd || Command.RECOMMEND_REQUEST == cmd) {
                    MESSAGE_LOGGER.info("pkg|c2eventMesh|cmd={}|pkg={}", (Object)cmd, (Object)pkg);
                    this.processTcpCommandRequest(pkg, ctx, startTime, cmd);
                    return;
                }
                if (AbstractTCPServer.this.clientSessionGroupMapping.getSession(ctx) == null) {
                    MESSAGE_LOGGER.info("pkg|c2eventMesh|cmd={}|pkg={}, no session is found", (Object)cmd, (Object)pkg);
                    throw new Exception("no session is found");
                }
                this.logMessageFlow(ctx, pkg, cmd);
                if (AbstractTCPServer.this.clientSessionGroupMapping.getSession(ctx).getSessionState() == SessionState.CLOSED) {
                    throw new Exception("this eventMesh tcp session will be closed, may be reboot or version change!");
                }
                this.processTcpCommandRequest(pkg, ctx, startTime, cmd);
            }
            catch (Exception e) {
                log.error("exception occurred while pkg|cmd={}|pkg={}", new Object[]{cmd, pkg, e});
                if (this.isNeedTrace(cmd)) {
                    Span span = TraceUtils.prepareServerSpan(pkg.getHeader().getProperties(), "upstream-eventmesh-server-span", startTime, TimeUnit.MILLISECONDS, false);
                    TraceUtils.finishSpanWithException(span, pkg.getHeader().getProperties(), "exception occurred while dispatch pkg", (Throwable)e);
                }
                this.writeToClient(cmd, pkg, ctx, e);
            }
        }

        private void processTcpCommandRequest(Package pkg, ChannelHandlerContext ctx, long startTime, Command cmd) {
            Pair pair = (Pair)AbstractTCPServer.this.tcpRequestProcessorTable.get(cmd);
            ((ThreadPoolExecutor)pair.getRight()).submit(() -> {
                TcpProcessor processor = (TcpProcessor)pair.getLeft();
                processor.process(pkg, ctx, startTime);
            });
        }

        private boolean isNeedTrace(Command cmd) {
            return AbstractTCPServer.this.eventMeshTCPConfiguration.isEventMeshServerTraceEnable() && (Command.REQUEST_TO_SERVER == cmd || Command.ASYNC_MESSAGE_TO_SERVER == cmd || Command.BROADCAST_MESSAGE_TO_SERVER == cmd);
        }

        private void writeToClient(Command cmd, Package pkg, ChannelHandlerContext ctx, Exception e) {
            try {
                Package res = new Package();
                res.setHeader(new Header(this.getReplyCommand(cmd), OPStatus.FAIL.getCode().intValue(), e.toString(), pkg.getHeader().getSeq()));
                ctx.channel().eventLoop().execute(() -> ctx.writeAndFlush((Object)res));
            }
            catch (Exception ex) {
                log.warn("writeToClient failed", (Throwable)ex);
            }
        }

        private Command getReplyCommand(Command cmd) {
            switch (cmd) {
                case HELLO_REQUEST: {
                    return Command.HELLO_RESPONSE;
                }
                case RECOMMEND_REQUEST: {
                    return Command.RECOMMEND_RESPONSE;
                }
                case HEARTBEAT_REQUEST: {
                    return Command.HEARTBEAT_RESPONSE;
                }
                case SUBSCRIBE_REQUEST: {
                    return Command.SUBSCRIBE_RESPONSE;
                }
                case UNSUBSCRIBE_REQUEST: {
                    return Command.UNSUBSCRIBE_RESPONSE;
                }
                case LISTEN_REQUEST: {
                    return Command.LISTEN_RESPONSE;
                }
                case CLIENT_GOODBYE_REQUEST: {
                    return Command.CLIENT_GOODBYE_RESPONSE;
                }
                case REQUEST_TO_SERVER: {
                    return Command.RESPONSE_TO_CLIENT;
                }
                case ASYNC_MESSAGE_TO_SERVER: {
                    return Command.ASYNC_MESSAGE_TO_SERVER_ACK;
                }
                case BROADCAST_MESSAGE_TO_SERVER: {
                    return Command.BROADCAST_MESSAGE_TO_SERVER_ACK;
                }
            }
            return cmd;
        }

        private void logMessageFlow(ChannelHandlerContext ctx, Package pkg, Command cmd) {
            if (!MESSAGE_LOGGER.isInfoEnabled()) {
                return;
            }
            if (pkg.getBody() instanceof EventMeshMessage) {
                MESSAGE_LOGGER.info("pkg|c2eventMesh|cmd={}|Msg={}|user={}", new Object[]{cmd, EventMeshUtil.printMqMessage((EventMeshMessage)pkg.getBody()), AbstractTCPServer.this.clientSessionGroupMapping.getSession(ctx).getClient()});
            } else {
                MESSAGE_LOGGER.info("pkg|c2eventMesh|cmd={}|pkg={}|user={}", new Object[]{cmd, pkg, AbstractTCPServer.this.clientSessionGroupMapping.getSession(ctx).getClient()});
            }
        }

        private void validateMsg(Package pkg) throws Exception {
            if (pkg == null) {
                throw new Exception("the incoming message is empty.");
            }
            if (pkg.getHeader() == null) {
                log.error("the incoming message does not have a header|pkg={}", (Object)pkg);
                throw new Exception("the incoming message does not have a header.");
            }
            if (pkg.getHeader().getCmd() == null) {
                log.error("the incoming message does not have a command type|pkg={}", (Object)pkg);
                throw new Exception("the incoming message does not have a command type.");
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Session session = AbstractTCPServer.this.clientSessionGroupMapping.getSession(ctx);
            UserAgent client = session == null ? null : session.getClient();
            log.error("exceptionCaught, push goodbye to client|user={}, errMsg={}", (Object)client, (Object)cause.fillInStackTrace());
            String errMsg = cause.toString().contains("value not one of declared Enum instance names") ? "Unknown Command type" : cause.toString();
            if (session != null) {
                EventMeshTcp2Client.goodBye2Client(AbstractTCPServer.this.tcpThreadPoolGroup, session, errMsg, OPStatus.FAIL.getCode(), AbstractTCPServer.this.clientSessionGroupMapping);
            } else {
                EventMeshTcp2Client.goodBye2Client(ctx, errMsg, AbstractTCPServer.this.clientSessionGroupMapping, AbstractTCPServer.this.eventMeshTcpMetricsManager);
            }
        }
    }

    private class TcpServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private TcpServerInitializer() {
        }

        protected void initChannel(SocketChannel ch) {
            AbstractTCPServer.this.globalTrafficShapingHandler = this.newGTSHandler(AbstractTCPServer.this.tcpThreadPoolGroup.getScheduler(), AbstractTCPServer.this.eventMeshTCPConfiguration.getCtc().getReadLimit());
            ch.pipeline().addLast(AbstractTCPServer.this.getWorkerGroup(), new ChannelHandler[]{new Codec.Encoder()}).addLast(AbstractTCPServer.this.getWorkerGroup(), new ChannelHandler[]{new Codec.Decoder()}).addLast(AbstractTCPServer.this.getWorkerGroup(), "global-traffic-shaping", (ChannelHandler)AbstractTCPServer.this.globalTrafficShapingHandler).addLast(AbstractTCPServer.this.getWorkerGroup(), "channel-traffic-shaping", (ChannelHandler)this.newCTSHandler(AbstractTCPServer.this.eventMeshTCPConfiguration.getCtc().getReadLimit())).addLast(AbstractTCPServer.this.getWorkerGroup(), new ChannelHandler[]{AbstractTCPServer.this.tcpConnectionHandler}).addLast(AbstractTCPServer.this.getWorkerGroup(), new ChannelHandler[]{new IdleStateHandler(AbstractTCPServer.this.eventMeshTCPConfiguration.getEventMeshTcpIdleReadSeconds(), AbstractTCPServer.this.eventMeshTCPConfiguration.getEventMeshTcpIdleWriteSeconds(), AbstractTCPServer.this.eventMeshTCPConfiguration.getEventMeshTcpIdleAllSeconds()), new TcpDispatcher()});
        }

        private GlobalTrafficShapingHandler newGTSHandler(ScheduledExecutorService executor, long readLimit) {
            GlobalTrafficShapingHandler handler = new GlobalTrafficShapingHandler(executor, 0L, readLimit){

                protected long calculateSize(Object msg) {
                    return 1L;
                }
            };
            handler.setMaxTimeWait(1000L);
            return handler;
        }

        private ChannelTrafficShapingHandler newCTSHandler(long readLimit) {
            ChannelTrafficShapingHandler handler = new ChannelTrafficShapingHandler(0L, readLimit){

                protected long calculateSize(Object msg) {
                    return 1L;
                }
            };
            handler.setMaxTimeWait(3000L);
            return handler;
        }
    }
}

