/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;

public class SSLContextFactory {
    public static SSLContext getSslContext(EventMeshHTTPConfiguration eventMeshHttpConfiguration) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        SSLContext sslContext;
        String protocol = eventMeshHttpConfiguration.getEventMeshServerSSLProtocol();
        String fileName = eventMeshHttpConfiguration.getEventMeshServerSSLCer();
        String password = eventMeshHttpConfiguration.getEventMeshServerSSLPass();
        try (InputStream inputStream = Files.newInputStream(Paths.get(EventMeshConstants.EVENTMESH_CONF_HOME + File.separator + fileName, new String[0]), StandardOpenOption.READ);){
            char[] filePass = StringUtils.isNotBlank((CharSequence)password) ? password.toCharArray() : new char[]{};
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inputStream, filePass);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, filePass);
            sslContext = SSLContext.getInstance(protocol);
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
        return sslContext;
    }
}

