/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class HttpRequestUtil {
    private static final DefaultHttpDataFactory DEFAULT_HTTP_DATA_FACTORY = new DefaultHttpDataFactory(false);

    public static <T> Map<String, Object> parseHttpRequestBody(HttpRequest httpRequest, @Nullable Supplier<T> start, @Nullable Consumer<T> end) throws IOException {
        Object t = null;
        if (!Objects.isNull(start)) {
            t = start.get();
        }
        HashMap<String, Object> httpRequestBody = new HashMap<String, Object>();
        if (HttpMethod.GET.equals((Object)httpRequest.method())) {
            new QueryStringDecoder(httpRequest.uri()).parameters().forEach((key, value) -> httpRequestBody.put((String)key, value.get(0)));
        } else if (HttpMethod.POST.equals((Object)httpRequest.method())) {
            HttpRequestUtil.decodeHttpRequestBody(httpRequest, httpRequestBody);
        }
        if (!Objects.isNull(end)) {
            end.accept(t);
        }
        return httpRequestBody;
    }

    public static Map<String, Object> parseHttpRequestBody(HttpRequest httpRequest) throws IOException {
        return HttpRequestUtil.parseHttpRequestBody(httpRequest, null, null);
    }

    private static void decodeHttpRequestBody(HttpRequest httpRequest, Map<String, Object> httpRequestBody) throws IOException {
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)DEFAULT_HTTP_DATA_FACTORY, httpRequest);
        for (InterfaceHttpData param : decoder.getBodyHttpDatas()) {
            if (InterfaceHttpData.HttpDataType.Attribute != param.getHttpDataType()) continue;
            Attribute data = (Attribute)param;
            httpRequestBody.put(data.getName(), data.getValue());
        }
        decoder.destroy();
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        if (queryString == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : queryString.split("&")) {
            String[] entry = param.split("=");
            if (entry.length > 1) {
                result.put(entry[0], entry[1]);
                continue;
            }
            result.put(entry[0], "");
        }
        return result;
    }

    public static String getQueryParam(HttpRequest httpRequest, String key, String defaultValue) {
        List values = (List)new QueryStringDecoder(httpRequest.uri()).parameters().get(key);
        return values != null ? (String)values.get(0) : defaultValue;
    }

    public static String getBodyParam(HttpRequest httpRequest, String key) throws IOException {
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(httpRequest);
        Attribute attribute = (Attribute)decoder.getBodyHttpData(key);
        return attribute.getValue();
    }
}

