/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.lock.LockGrpc;
import io.etcd.jetcd.api.lock.LockRequest;
import io.etcd.jetcd.api.lock.UnlockRequest;
import io.etcd.jetcd.lock.LockResponse;
import io.etcd.jetcd.lock.UnlockResponse;
import java.util.concurrent.CompletableFuture;

final class LockImpl
implements Lock {
    private final ClientConnectionManager connectionManager;
    private final LockGrpc.LockFutureStub stub;

    LockImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(LockGrpc::newFutureStub);
    }

    @Override
    public CompletableFuture<LockResponse> lock(ByteSequence name, long leaseId) {
        Preconditions.checkNotNull((Object)name);
        LockRequest request = LockRequest.newBuilder().setName(name.getByteString()).setLease(leaseId).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.lock(request), LockResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<UnlockResponse> unlock(ByteSequence lockKey) {
        Preconditions.checkNotNull((Object)lockKey);
        UnlockRequest request = UnlockRequest.newBuilder().setKey(lockKey.getByteString()).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.unlock(request), UnlockResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }
}

