/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TableMeta {
    private String schema;
    private String table;
    private List<FieldMeta> fields = new ArrayList<FieldMeta>();
    private String ddl;

    public TableMeta() {
    }

    public TableMeta(String schema, String table, List<FieldMeta> fields) {
        this.schema = schema;
        this.table = table;
        this.fields = fields;
    }

    public String getFullName() {
        return this.schema + "." + this.table;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public List<FieldMeta> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldMeta> fileds) {
        this.fields = fileds;
    }

    public FieldMeta getFieldMetaByName(String name) {
        for (FieldMeta meta : this.fields) {
            if (!meta.getColumnName().equalsIgnoreCase(name)) continue;
            return meta;
        }
        throw new RuntimeException("unknow column : " + name);
    }

    public List<FieldMeta> getPrimaryFields() {
        ArrayList<FieldMeta> primarys = new ArrayList<FieldMeta>();
        for (FieldMeta meta : this.fields) {
            if (!meta.isKey()) continue;
            primarys.add(meta);
        }
        return primarys;
    }

    public String getDdl() {
        return this.ddl;
    }

    public void setDdl(String ddl) {
        this.ddl = ddl;
    }

    public void addFieldMeta(FieldMeta fieldMeta) {
        this.fields.add(fieldMeta);
    }

    public String toString() {
        StringBuilder data = new StringBuilder();
        data.append("TableMeta [schema=" + this.schema + ", table=" + this.table + ", fileds=");
        for (FieldMeta field : this.fields) {
            data.append("\n\t").append(field.toString());
        }
        data.append("\n]");
        return data.toString();
    }

    public static class FieldMeta {
        private String columnName;
        private String columnType;
        private boolean nullable;
        private boolean key;
        private String defaultValue;
        private String extra;
        private boolean unique;

        public FieldMeta() {
        }

        public FieldMeta(String columnName, String columnType, boolean nullable, boolean key, String defaultValue) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.nullable = nullable;
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isUnsigned() {
            return StringUtils.containsIgnoreCase((String)this.columnType, (String)"unsigned");
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isKey() {
            return this.key;
        }

        public void setKey(boolean key) {
            this.key = key;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean unique) {
            this.unique = unique;
        }

        public String toString() {
            return "FieldMeta [columnName=" + this.columnName + ", columnType=" + this.columnType + ", nullable=" + this.nullable + ", key=" + this.key + ", defaultValue=" + this.defaultValue + ", extra=" + this.extra + ", unique=" + this.unique + "]";
        }
    }
}

