/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.index.AbstractLogPositionManager;
import com.alibaba.otter.canal.parse.index.MemoryLogPositionManager;
import com.alibaba.otter.canal.parse.index.ZooKeeperLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodMixedLogPositionManager
extends AbstractLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(PeriodMixedLogPositionManager.class);
    private MemoryLogPositionManager memoryLogPositionManager;
    private ZooKeeperLogPositionManager zooKeeperLogPositionManager;
    private ScheduledExecutorService executorService;
    private long period;
    private Set<String> persistTasks;
    private final LogPosition nullPosition = new LogPosition(){};

    public PeriodMixedLogPositionManager(MemoryLogPositionManager memoryLogPositionManager, ZooKeeperLogPositionManager zooKeeperLogPositionManager, long period) {
        if (memoryLogPositionManager == null) {
            throw new NullPointerException("null memoryLogPositionManager");
        }
        if (zooKeeperLogPositionManager == null) {
            throw new NullPointerException("null zooKeeperLogPositionManager");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be positive, given: " + period);
        }
        this.memoryLogPositionManager = memoryLogPositionManager;
        this.zooKeeperLogPositionManager = zooKeeperLogPositionManager;
        this.period = period;
        this.persistTasks = Collections.synchronizedSet(new HashSet());
        this.executorService = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        super.stop();
        if (this.zooKeeperLogPositionManager.isStart()) {
            this.zooKeeperLogPositionManager.stop();
        }
        if (this.memoryLogPositionManager.isStart()) {
            this.memoryLogPositionManager.stop();
        }
        this.executorService.shutdown();
    }

    public void start() {
        super.start();
        if (!this.memoryLogPositionManager.isStart()) {
            this.memoryLogPositionManager.start();
        }
        if (!this.zooKeeperLogPositionManager.isStart()) {
            this.zooKeeperLogPositionManager.start();
        }
        this.executorService.scheduleAtFixedRate(() -> {
            ArrayList<String> tasks = new ArrayList<String>(this.persistTasks);
            for (String destination : tasks) {
                try {
                    this.zooKeeperLogPositionManager.persistLogPosition(destination, this.getLatestIndexBy(destination));
                    this.persistTasks.remove(destination);
                }
                catch (Throwable e) {
                    logger.error("period update" + destination + " curosr failed!", e);
                }
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPosition = this.memoryLogPositionManager.getLatestIndexBy(destination);
        if (logPosition == this.nullPosition) {
            return null;
        }
        return logPosition;
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) throws CanalParseException {
        this.persistTasks.add(destination);
        this.memoryLogPositionManager.persistLogPosition(destination, logPosition);
    }
}

