/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.sink;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mcp.McpSinkConfig;
import org.apache.eventmesh.common.config.connector.mcp.SinkConnectorConfig;
import org.apache.eventmesh.connector.mcp.sink.handler.McpSinkHandler;
import org.apache.eventmesh.connector.mcp.sink.handler.impl.CommonMcpSinkHandler;
import org.apache.eventmesh.connector.mcp.sink.handler.impl.McpSinkHandlerRetryWrapper;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpSinkConnector
implements Sink,
ConnectorCreateService<Sink> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpSinkConnector.class);
    private McpSinkConfig mcpSinkConfig;
    private McpSinkHandler sinkHandler;
    private ThreadPoolExecutor executor;
    private final AtomicBoolean isStart = new AtomicBoolean(false);

    public Class<? extends Config> configClass() {
        return McpSinkConfig.class;
    }

    public Sink create() {
        return new McpSinkConnector();
    }

    public void init(Config config) throws Exception {
        this.mcpSinkConfig = (McpSinkConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.mcpSinkConfig = (McpSinkConfig)sinkConnectorContext.getSinkConfig();
        this.doInit();
    }

    private void doInit() {
        SinkConnectorConfig.populateFieldsWithDefaults((SinkConnectorConfig)this.mcpSinkConfig.connectorConfig);
        CommonMcpSinkHandler nonRetryHandler = new CommonMcpSinkHandler(this.mcpSinkConfig.connectorConfig);
        int maxRetries = this.mcpSinkConfig.connectorConfig.getRetryConfig().getMaxRetries();
        if (maxRetries == 0) {
            this.sinkHandler = nonRetryHandler;
        } else if (maxRetries > 0) {
            this.sinkHandler = new McpSinkHandlerRetryWrapper(this.mcpSinkConfig.connectorConfig, nonRetryHandler);
        } else {
            throw new IllegalArgumentException("Max retries must be greater than or equal to 0.");
        }
        boolean isParallelized = this.mcpSinkConfig.connectorConfig.isParallelized();
        int parallelism = isParallelized ? this.mcpSinkConfig.connectorConfig.getParallelism() : 1;
        this.executor = new ThreadPoolExecutor(parallelism, parallelism, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new EventMeshThreadFactory("mcp-sink-handler"));
    }

    public void start() throws Exception {
        this.sinkHandler.start();
        this.isStart.set(true);
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.mcpSinkConfig.connectorConfig.getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws Exception {
        this.isStart.set(false);
        log.info("Stopping mcp sink connector, shutting down executor...");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.warn("Executor did not terminate gracefully, forcing shutdown");
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.error("Executor did not terminate after forced shutdown");
                }
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for executor termination");
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.sinkHandler.stop();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        if (!this.isStart.get()) {
            log.warn("Connector is not started, ignoring sink records");
            return;
        }
        for (ConnectRecord sinkRecord : sinkRecords) {
            if (Objects.isNull(sinkRecord)) {
                log.warn("ConnectRecord data is null, ignore.");
                continue;
            }
            log.info("McpSinkConnector put record: {}", (Object)sinkRecord);
            try {
                this.executor.submit(() -> {
                    try {
                        this.sinkHandler.handle(sinkRecord);
                    }
                    catch (Exception e) {
                        log.error("Failed to handle sink record via mcp", (Throwable)e);
                    }
                });
            }
            catch (Exception e) {
                log.error("Failed to submit sink record to executor", (Throwable)e);
            }
        }
    }

    @Generated
    public McpSinkHandler getSinkHandler() {
        return this.sinkHandler;
    }
}

