/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.apache.eventmesh.common.config.connector.offset.OffsetStorageConfig;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.SystemUtils;
import org.apache.eventmesh.openconnect.ConnectorWorker;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendExceptionContext;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendMessageCallback;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendResult;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffsetManagement;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.DefaultOffsetManagementServiceImpl;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetManagementService;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageReader;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageReaderImpl;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageWriterImpl;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceWorker
implements ConnectorWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceWorker.class);
    private final Source source;
    private final SourceConfig config;
    private static final int MAX_RETRY_TIMES = 3;
    public static final String CALLBACK_EXTENSION = "callBackExtension";
    private OffsetStorageWriterImpl offsetStorageWriter;
    private OffsetStorageReaderImpl offsetStorageReader;
    private OffsetManagementService offsetManagementService;
    private RecordOffsetManagement offsetManagement;
    private volatile RecordOffsetManagement.CommittableOffsets committableOffsets;
    private final ExecutorService pollService = ThreadPoolFactory.createSingleExecutor((String)"eventMesh-sourceWorker-pollService");
    private final ExecutorService startService = ThreadPoolFactory.createSingleExecutor((String)"eventMesh-sourceWorker-startService");
    private final BlockingQueue<ConnectRecord> queue;
    private final EventMeshTCPClient<CloudEvent> eventMeshTCPClient;
    private volatile boolean isRunning = false;

    public SourceWorker(Source source, SourceConfig config) {
        this.source = source;
        this.config = config;
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
        this.eventMeshTCPClient = this.buildEventMeshPubClient(config);
    }

    private EventMeshTCPClient<CloudEvent> buildEventMeshPubClient(SourceConfig config) {
        String meshAddress = config.getPubSubConfig().getMeshAddress();
        String meshIp = meshAddress.split(":")[0];
        int meshPort = Integer.parseInt(meshAddress.split(":")[1]);
        UserAgent agent = UserAgent.builder().env(config.getPubSubConfig().getEnv()).host("localhost").password(config.getPubSubConfig().getPassWord()).username(config.getPubSubConfig().getUserName()).group(config.getPubSubConfig().getGroup()).path("/").port(8362).subsystem(config.getPubSubConfig().getAppId()).pid(Integer.parseInt(SystemUtils.getProcessId())).version("2.0").idc(config.getPubSubConfig().getIdc()).build();
        UserAgent userAgent = MessageUtils.generatePubClient((UserAgent)agent);
        EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(meshIp).port(meshPort).userAgent(userAgent).build();
        return EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, CloudEvent.class);
    }

    @Override
    public void init() {
        SourceConnectorContext sourceConnectorContext = new SourceConnectorContext();
        sourceConnectorContext.setSourceConfig(this.config);
        sourceConnectorContext.setOffsetStorageReader((OffsetStorageReader)this.offsetStorageReader);
        try {
            this.source.init(sourceConnectorContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.eventMeshTCPClient.init();
        this.offsetManagement = new RecordOffsetManagement();
        this.committableOffsets = RecordOffsetManagement.CommittableOffsets.EMPTY;
        OffsetStorageConfig offsetStorageConfig = this.config.getOffsetStorageConfig();
        this.offsetManagementService = Optional.ofNullable(offsetStorageConfig).map(OffsetStorageConfig::getOffsetStorageType).map(storageType -> (OffsetManagementService)EventMeshExtensionFactory.getExtension(OffsetManagementService.class, (String)storageType)).orElse((OffsetManagementService)new DefaultOffsetManagementServiceImpl());
        this.offsetManagementService.initialize(offsetStorageConfig);
        this.offsetStorageWriter = new OffsetStorageWriterImpl(this.offsetManagementService);
        this.offsetStorageReader = new OffsetStorageReaderImpl(this.offsetManagementService);
    }

    @Override
    public void start() {
        log.info("source worker starting {}", (Object)this.source.name());
        log.info("event mesh address is {}", (Object)this.config.getPubSubConfig().getMeshAddress());
        this.offsetManagementService.start();
        this.isRunning = true;
        this.pollService.execute(this::startPollAndSend);
        this.startService.execute(() -> {
            try {
                this.startConnector();
            }
            catch (Exception e) {
                log.error("source worker[{}] start fail", (Object)this.source.name(), (Object)e);
                this.stop();
            }
        });
    }

    public void startPollAndSend() {
        while (this.isRunning) {
            ConnectRecord connectRecord = null;
            try {
                connectRecord = this.queue.poll(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("poll connect record error", (Throwable)e);
            }
            if (connectRecord == null) continue;
            CloudEvent event = this.convertRecordToEvent(connectRecord);
            Optional<RecordOffsetManagement.SubmittedPosition> submittedRecordPosition = this.prepareToUpdateRecordOffset(connectRecord);
            Optional<SendMessageCallback> callback = Optional.ofNullable(connectRecord.getExtensionObj(CALLBACK_EXTENSION)).map(v -> (SendMessageCallback)v);
            int retryTimes = 0;
            while (retryTimes < 3) {
                try {
                    Package sendResult = this.eventMeshTCPClient.publish((Object)event, 3000L);
                    if (sendResult.getHeader().getCode() != OPStatus.SUCCESS.getCode().intValue()) {
                        throw new EventMeshException("failed to send record.");
                    }
                    this.source.commit(connectRecord);
                    submittedRecordPosition.ifPresent(RecordOffsetManagement.SubmittedPosition::ack);
                    callback.ifPresent(cb -> cb.onSuccess(this.convertToSendResult(event)));
                    break;
                }
                catch (Throwable t) {
                    log.error("{} failed to send record to {}, retry times = {}, failed record {}, throw {}", new Object[]{this, event.getSubject(), ++retryTimes, connectRecord, t.getMessage()});
                    callback.ifPresent(cb -> cb.onException(this.convertToExceptionContext(event, t)));
                }
            }
            this.offsetManagement.awaitAllMessages(5000L, TimeUnit.MILLISECONDS);
            this.updateCommittableOffsets();
            this.commitOffsets();
        }
    }

    private void startConnector() throws Exception {
        this.source.start();
        while (this.isRunning) {
            List<ConnectRecord> connectorRecordList = this.source.poll();
            if (CollectionUtils.isEmpty(connectorRecordList)) continue;
            for (ConnectRecord record : connectorRecordList) {
                this.queue.put(record);
            }
        }
    }

    private CloudEvent convertRecordToEvent(ConnectRecord connectRecord) {
        io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = CloudEventBuilder.v1();
        cloudEventBuilder.withId(UUID.randomUUID().toString()).withSubject(this.config.getPubSubConfig().getSubject()).withSource(URI.create("/")).withDataContentType("application/cloudevents+json").withType("cloudevents").withData(Objects.requireNonNull(JsonUtils.toJSONString((Object)connectRecord.getData())).getBytes(StandardCharsets.UTF_8)).withExtension("ttl", (Number)10000);
        if (connectRecord.getExtensions() != null) {
            for (String key : connectRecord.getExtensions().keySet()) {
                if (!CloudEventUtil.validateExtensionType(connectRecord.getExtensionObj(key))) continue;
                cloudEventBuilder.withExtension(key, connectRecord.getExtension(key));
            }
        }
        return cloudEventBuilder.build();
    }

    private SendResult convertToSendResult(CloudEvent event) {
        SendResult result = new SendResult();
        result.setMessageId(event.getId());
        result.setTopic(event.getSubject());
        return result;
    }

    private SendExceptionContext convertToExceptionContext(CloudEvent event, Throwable cause) {
        SendExceptionContext exceptionContext = new SendExceptionContext();
        exceptionContext.setTopic(event.getId());
        exceptionContext.setMessageId(event.getId());
        exceptionContext.setCause(cause);
        return exceptionContext;
    }

    @Override
    public void stop() {
        log.info("source worker stopping");
        this.isRunning = false;
        try {
            this.source.stop();
        }
        catch (Exception e) {
            log.error("source destroy error", (Throwable)e);
        }
        log.info("pollService stopping");
        this.pollService.shutdown();
        try {
            this.pollService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("awaitTermination error", (Throwable)e);
        }
        log.info("offsetMgmtService stopping");
        this.offsetManagementService.stop();
        try {
            log.info("eventmesh client closing");
            this.eventMeshTCPClient.close();
        }
        catch (Exception e) {
            log.error("event mesh client close error", (Throwable)e);
        }
        log.info("source worker stopped");
    }

    public Optional<RecordOffsetManagement.SubmittedPosition> prepareToUpdateRecordOffset(ConnectRecord record) {
        return Optional.of(this.offsetManagement.submitRecord(record.getPosition()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCommittableOffsets() {
        RecordOffsetManagement.CommittableOffsets newOffsets = this.offsetManagement.committableOffsets();
        SourceWorker sourceWorker = this;
        synchronized (sourceWorker) {
            this.committableOffsets = this.committableOffsets.updatedWith(newOffsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitOffsets() {
        RecordOffsetManagement.CommittableOffsets offsetsToCommit;
        log.info("Start Committing offsets");
        long timeout = System.currentTimeMillis() + 5000L;
        SourceWorker sourceWorker = this;
        synchronized (sourceWorker) {
            offsetsToCommit = this.committableOffsets;
            this.committableOffsets = RecordOffsetManagement.CommittableOffsets.EMPTY;
        }
        if (this.committableOffsets.isEmpty()) {
            log.debug("Either no records were produced since the last offset commit, or every record has been filtered out by a transformation or dropped due to transformation or conversion errors.");
        } else {
            log.info("{} Committing offsets for {} acknowledged messages", (Object)this, (Object)this.committableOffsets.numCommittableMessages());
            if (this.committableOffsets.hasPending()) {
                log.debug("{} There are currently {} pending messages spread across {} source partitions whose offsets will not be committed. The source partition with the most pending messages is {}, with {} pending messages", new Object[]{this, this.committableOffsets.numUncommittableMessages(), this.committableOffsets.numDeques(), this.committableOffsets.largestDequePartition(), this.committableOffsets.largestDequeSize()});
            } else {
                log.debug("{} There are currently no pending messages for this offset commit; all messages dispatched to the task's producer since the last commit have been acknowledged", (Object)this);
            }
        }
        offsetsToCommit.offsets().forEach((arg_0, arg_1) -> ((OffsetStorageWriterImpl)this.offsetStorageWriter).writeOffset(arg_0, arg_1));
        if (!this.offsetStorageWriter.beginFlush()) {
            return true;
        }
        Future flushFuture = this.offsetStorageWriter.doFlush();
        try {
            flushFuture.get(Math.max(timeout - System.currentTimeMillis(), 0L), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("{} Flush of offsets interrupted, cancelling", (Object)this);
            this.offsetStorageWriter.cancelFlush();
            return false;
        }
        catch (ExecutionException e) {
            log.error("{} Flush of offsets threw an unexpected exception: ", (Object)this, (Object)e);
            this.offsetStorageWriter.cancelFlush();
            return false;
        }
        catch (TimeoutException e) {
            log.error("{} Timed out waiting to flush offsets to storage; will try again on next flush interval with latest offsets", (Object)this);
            this.offsetStorageWriter.cancelFlush();
            return false;
        }
        return true;
    }
}

