/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.cob.domain.LoanAccountLock;
import org.apache.fineract.cob.domain.LoanAccountLockRepository;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Profile(value={"test"})
@Component
@Path(value="/v1/internal/loans")
public class InternalLoanAccountLockApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalLoanAccountLockApiResource.class);
    private final LoanAccountLockRepository loanAccountLockRepository;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() throws Exception {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Internal client services mode is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @POST
    @Path(value="{loanId}/place-lock/{lockOwner}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public Response placeLockOnLoanAccount(@Context UriInfo uriInfo, @PathParam(value="loanId") Long loanId, @PathParam(value="lockOwner") String lockOwner, @RequestBody(required=false) String error) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Placing lock on loan: {}", (Object)loanId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        LoanAccountLock loanAccountLock = new LoanAccountLock(loanId, LockOwner.valueOf((String)lockOwner), ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE));
        if (StringUtils.isNotBlank((CharSequence)error)) {
            loanAccountLock.setError(error, error);
        }
        this.loanAccountLockRepository.save((Object)loanAccountLock);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @Generated
    public InternalLoanAccountLockApiResource(LoanAccountLockRepository loanAccountLockRepository) {
        this.loanAccountLockRepository = loanAccountLockRepository;
    }
}

