/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.loan;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.constants.TemplatePopulateImportConstants;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ChargeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ExtrasSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.GroupSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.LoanProductSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class LoanWorkbookPopulator
extends AbstractWorkbookPopulator {
    private OfficeSheetPopulator officeSheetPopulator;
    private ClientSheetPopulator clientSheetPopulator;
    private GroupSheetPopulator groupSheetPopulator;
    private PersonnelSheetPopulator personnelSheetPopulator;
    private LoanProductSheetPopulator productSheetPopulator;
    private ChargeSheetPopulator chargeSheetPopulator;
    private ExtrasSheetPopulator extrasSheetPopulator;

    public LoanWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, ClientSheetPopulator clientSheetPopulator, GroupSheetPopulator groupSheetPopulator, PersonnelSheetPopulator personnelSheetPopulator, LoanProductSheetPopulator productSheetPopulator, ChargeSheetPopulator chargeSheetPopulator, ExtrasSheetPopulator extrasSheetPopulator) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
        this.groupSheetPopulator = groupSheetPopulator;
        this.personnelSheetPopulator = personnelSheetPopulator;
        this.productSheetPopulator = productSheetPopulator;
        this.extrasSheetPopulator = extrasSheetPopulator;
        this.chargeSheetPopulator = chargeSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet loanSheet = workbook.createSheet("Loans");
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.groupSheetPopulator.populate(workbook, dateFormat);
        this.personnelSheetPopulator.populate(workbook, dateFormat);
        this.productSheetPopulator.populate(workbook, dateFormat);
        this.chargeSheetPopulator.populate(workbook, dateFormat);
        this.extrasSheetPopulator.populate(workbook, dateFormat);
        this.setLayout(loanSheet);
        this.setRules(loanSheet, dateFormat);
        this.setDefaults(loanSheet);
        this.setClientAndGroupDateLookupTable(loanSheet, this.clientSheetPopulator.getClients(), this.groupSheetPopulator.getGroups(), 43, 45, TemplatePopulateImportConstants.CONTAINS_CLIENT_EXTERNAL_ID.booleanValue(), dateFormat);
    }

    private void setRules(Sheet worksheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList loanTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList clientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList productNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 4, 4);
        CellRangeAddressList loanOfficerRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList submittedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList fundNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 10, 10);
        CellRangeAddressList principalRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 11, 11);
        CellRangeAddressList noOfRepaymentsRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 12, 12);
        CellRangeAddressList repaidFrequencyRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 14, 14);
        CellRangeAddressList loanTermRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 15, 15);
        CellRangeAddressList loanTermFrequencyRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 16, 16);
        CellRangeAddressList interestFrequencyRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 18, 18);
        CellRangeAddressList interestRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 17, 17);
        CellRangeAddressList amortizationRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 19, 19);
        CellRangeAddressList interestMethodRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 20, 20);
        CellRangeAddressList intrestCalculationPeriodRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 21, 21);
        CellRangeAddressList repaymentStrategyRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 23, 23);
        CellRangeAddressList arrearsToleranceRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 22, 22);
        CellRangeAddressList graceOnPrincipalPaymentRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 24, 24);
        CellRangeAddressList graceOnInterestPaymentRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 25, 25);
        CellRangeAddressList graceOnInterestChargedRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 26, 26);
        CellRangeAddressList approvedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        CellRangeAddressList disbursedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 8, 8);
        CellRangeAddressList paymentTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 9, 9);
        CellRangeAddressList repaymentTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 31, 31);
        CellRangeAddressList lastrepaymentDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 30, 30);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        CellRangeAddressList chargeOneNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 36, 36);
        CellRangeAddressList chargeOneAmountTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 49, 49);
        CellRangeAddressList chargeTwoNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 39, 39);
        CellRangeAddressList chargeTwoAmountTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 50, 50);
        this.setNames(worksheet);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint loanTypeConstraint = validationHelper.createExplicitListConstraint(new String[]{"Individual", "Group", "JLG"});
        DataValidationConstraint clientNameConstraint = validationHelper.createFormulaListConstraint("IF($B1=\"Group\",INDIRECT(CONCATENATE(\"Group_\",$A1)),INDIRECT(CONCATENATE(\"Client_\",$A1)))");
        DataValidationConstraint productNameConstraint = validationHelper.createFormulaListConstraint("Products");
        DataValidationConstraint loanOfficerNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Staff_\",$A1))");
        DataValidationConstraint submittedDateConstraint = validationHelper.createDateConstraint(0, "=IF(DATEVALUE(INDIRECT(\"START_DATE_\" & $E1)) > DATEVALUE(VLOOKUP($C1, $AR$2:$AT$" + (this.clientSheetPopulator.getClientsSize() + this.groupSheetPopulator.getGroupsSize() + 1) + ", 3, FALSE)), DATEVALUE(INDIRECT(\"START_DATE_\" & $E1)), DATEVALUE(VLOOKUP($C1, $AR$2:$AT$" + (this.clientSheetPopulator.getClientsSize() + this.groupSheetPopulator.getGroupsSize() + 1) + ", 3, FALSE)))", "=TODAY()", dateFormat);
        DataValidationConstraint approvalDateConstraint = validationHelper.createDateConstraint(0, "=$G1", "=TODAY()", dateFormat);
        DataValidationConstraint disbursedDateConstraint = validationHelper.createDateConstraint(0, "=$H1", "=TODAY()", dateFormat);
        DataValidationConstraint paymentTypeConstraint = validationHelper.createFormulaListConstraint("PaymentTypes");
        DataValidationConstraint fundNameConstraint = validationHelper.createFormulaListConstraint("Funds");
        DataValidationConstraint principalConstraint = validationHelper.createDecimalConstraint(0, "=INDIRECT(CONCATENATE(\"MIN_PRINCIPAL_\",$E1))", "=INDIRECT(CONCATENATE(\"MAX_PRINCIPAL_\",$E1))");
        DataValidationConstraint noOfRepaymentsConstraint = validationHelper.createIntegerConstraint(0, "=INDIRECT(CONCATENATE(\"MIN_REPAYMENT_\",$E1))", "=INDIRECT(CONCATENATE(\"MAX_REPAYMENT_\",$E1))");
        DataValidationConstraint frequencyConstraint = validationHelper.createExplicitListConstraint(new String[]{"Days", "Weeks", "Months", "Semi Month"});
        DataValidationConstraint loanTermFrequencyConstraint = validationHelper.createExplicitListConstraint(new String[]{"Days", "Weeks", "Months"});
        DataValidationConstraint loanTermConstraint = validationHelper.createIntegerConstraint(6, "=$M1/$N1", "=$M1*$N1");
        DataValidationConstraint interestFrequencyConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"INTEREST_FREQUENCY_\",$E1))");
        DataValidationConstraint interestConstraint = validationHelper.createDecimalConstraint(0, "=INDIRECT(CONCATENATE(\"MIN_INTEREST_\",$E1))", "=INDIRECT(CONCATENATE(\"MAX_INTEREST_\",$E1))");
        DataValidationConstraint amortizationConstraint = validationHelper.createExplicitListConstraint(new String[]{"Equal principal payments", "Equal installments"});
        DataValidationConstraint interestMethodConstraint = validationHelper.createExplicitListConstraint(new String[]{"Flat", "Declining Balance"});
        DataValidationConstraint interestCalculationPeriodConstraint = validationHelper.createExplicitListConstraint(new String[]{"Daily", "Same as repayment period"});
        DataValidationConstraint repaymentStrategyConstraint = validationHelper.createExplicitListConstraint(new String[]{"Penalties, Fees, Interest, Principal order", "HeavensFamily Unique", "Creocore Unique", "Overdue/Due Fee/Int,Principal", "Principal, Interest, Penalties, Fees Order", "Interest, Principal, Penalties, Fees Order", "Early Repayment Strategy"});
        DataValidationConstraint arrearsToleranceConstraint = validationHelper.createIntegerConstraint(6, "0", null);
        DataValidationConstraint graceOnPrincipalPaymentConstraint = validationHelper.createIntegerConstraint(6, "0", null);
        DataValidationConstraint graceOnInterestPaymentConstraint = validationHelper.createIntegerConstraint(6, "0", null);
        DataValidationConstraint graceOnInterestChargedConstraint = validationHelper.createIntegerConstraint(6, "0", null);
        DataValidationConstraint lastRepaymentDateConstraint = validationHelper.createDateConstraint(0, "=$I1", "=TODAY()", dateFormat);
        DataValidationConstraint chargeOneNameConstraint = validationHelper.createFormulaListConstraint("Charges");
        DataValidationConstraint chargeOneAmountTypeConstraint = validationHelper.createExplicitListConstraint(new String[]{"Flat", "% Amount"});
        DataValidationConstraint chargeTwoNameConstraint = validationHelper.createFormulaListConstraint("Charges");
        DataValidationConstraint chargeTwoAmountTypeConstraint = validationHelper.createExplicitListConstraint(new String[]{"Flat", "% Amount"});
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation loanTypeValidation = validationHelper.createValidation(loanTypeConstraint, loanTypeRange);
        DataValidation clientValidation = validationHelper.createValidation(clientNameConstraint, clientNameRange);
        DataValidation productNameValidation = validationHelper.createValidation(productNameConstraint, productNameRange);
        DataValidation loanOfficerValidation = validationHelper.createValidation(loanOfficerNameConstraint, loanOfficerRange);
        DataValidation fundNameValidation = validationHelper.createValidation(fundNameConstraint, fundNameRange);
        DataValidation repaidFrequencyValidation = validationHelper.createValidation(frequencyConstraint, repaidFrequencyRange);
        DataValidation loanTermFrequencyValidation = validationHelper.createValidation(loanTermFrequencyConstraint, loanTermFrequencyRange);
        DataValidation amortizationValidation = validationHelper.createValidation(amortizationConstraint, amortizationRange);
        DataValidation interestMethodValidation = validationHelper.createValidation(interestMethodConstraint, interestMethodRange);
        DataValidation interestCalculationPeriodValidation = validationHelper.createValidation(interestCalculationPeriodConstraint, intrestCalculationPeriodRange);
        DataValidation repaymentStrategyValidation = validationHelper.createValidation(repaymentStrategyConstraint, repaymentStrategyRange);
        DataValidation paymentTypeValidation = validationHelper.createValidation(paymentTypeConstraint, paymentTypeRange);
        DataValidation repaymentTypeValidation = validationHelper.createValidation(paymentTypeConstraint, repaymentTypeRange);
        DataValidation submittedDateValidation = validationHelper.createValidation(submittedDateConstraint, submittedDateRange);
        DataValidation approvalDateValidation = validationHelper.createValidation(approvalDateConstraint, approvedDateRange);
        DataValidation disbursedDateValidation = validationHelper.createValidation(disbursedDateConstraint, disbursedDateRange);
        DataValidation lastRepaymentDateValidation = validationHelper.createValidation(lastRepaymentDateConstraint, lastrepaymentDateRange);
        DataValidation principalValidation = validationHelper.createValidation(principalConstraint, principalRange);
        DataValidation loanTermValidation = validationHelper.createValidation(loanTermConstraint, loanTermRange);
        DataValidation noOfRepaymentsValidation = validationHelper.createValidation(noOfRepaymentsConstraint, noOfRepaymentsRange);
        DataValidation interestValidation = validationHelper.createValidation(interestConstraint, interestRange);
        DataValidation arrearsToleranceValidation = validationHelper.createValidation(arrearsToleranceConstraint, arrearsToleranceRange);
        DataValidation graceOnPrincipalPaymentValidation = validationHelper.createValidation(graceOnPrincipalPaymentConstraint, graceOnPrincipalPaymentRange);
        DataValidation graceOnInterestPaymentValidation = validationHelper.createValidation(graceOnInterestPaymentConstraint, graceOnInterestPaymentRange);
        DataValidation graceOnInterestChargedValidation = validationHelper.createValidation(graceOnInterestChargedConstraint, graceOnInterestChargedRange);
        DataValidation interestFrequencyValidation = validationHelper.createValidation(interestFrequencyConstraint, interestFrequencyRange);
        DataValidation chargeOneNameValidation = validationHelper.createValidation(chargeOneNameConstraint, chargeOneNameRange);
        DataValidation chargeOneAmountTypeValidation = validationHelper.createValidation(chargeOneAmountTypeConstraint, chargeOneAmountTypeRange);
        DataValidation chargeTwoNameValidation = validationHelper.createValidation(chargeTwoNameConstraint, chargeTwoNameRange);
        DataValidation chargeTwoAmountTypeValidation = validationHelper.createValidation(chargeTwoAmountTypeConstraint, chargeTwoAmountTypeRange);
        interestFrequencyValidation.setSuppressDropDownArrow(true);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(loanTypeValidation);
        worksheet.addValidationData(clientValidation);
        worksheet.addValidationData(productNameValidation);
        worksheet.addValidationData(loanOfficerValidation);
        worksheet.addValidationData(submittedDateValidation);
        worksheet.addValidationData(approvalDateValidation);
        worksheet.addValidationData(disbursedDateValidation);
        worksheet.addValidationData(paymentTypeValidation);
        worksheet.addValidationData(fundNameValidation);
        worksheet.addValidationData(principalValidation);
        worksheet.addValidationData(repaidFrequencyValidation);
        worksheet.addValidationData(loanTermFrequencyValidation);
        worksheet.addValidationData(noOfRepaymentsValidation);
        worksheet.addValidationData(loanTermValidation);
        worksheet.addValidationData(interestValidation);
        worksheet.addValidationData(interestFrequencyValidation);
        worksheet.addValidationData(amortizationValidation);
        worksheet.addValidationData(interestMethodValidation);
        worksheet.addValidationData(interestCalculationPeriodValidation);
        worksheet.addValidationData(repaymentStrategyValidation);
        worksheet.addValidationData(arrearsToleranceValidation);
        worksheet.addValidationData(graceOnPrincipalPaymentValidation);
        worksheet.addValidationData(graceOnInterestPaymentValidation);
        worksheet.addValidationData(graceOnInterestChargedValidation);
        worksheet.addValidationData(lastRepaymentDateValidation);
        worksheet.addValidationData(repaymentTypeValidation);
        worksheet.addValidationData(chargeOneNameValidation);
        worksheet.addValidationData(chargeOneAmountTypeValidation);
        worksheet.addValidationData(chargeTwoNameValidation);
        worksheet.addValidationData(chargeTwoAmountTypeValidation);
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 4000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 6000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(17, 4000);
        worksheet.setColumnWidth(18, 4000);
        worksheet.setColumnWidth(19, 6000);
        worksheet.setColumnWidth(20, 4000);
        worksheet.setColumnWidth(21, 4000);
        worksheet.setColumnWidth(22, 4000);
        worksheet.setColumnWidth(23, 4000);
        worksheet.setColumnWidth(24, 4000);
        worksheet.setColumnWidth(25, 4000);
        worksheet.setColumnWidth(26, 4000);
        worksheet.setColumnWidth(27, 4000);
        worksheet.setColumnWidth(28, 4000);
        worksheet.setColumnWidth(29, 4000);
        worksheet.setColumnWidth(30, 4000);
        worksheet.setColumnWidth(31, 4000);
        worksheet.setColumnWidth(43, 6000);
        worksheet.setColumnWidth(44, 6000);
        worksheet.setColumnWidth(45, 6000);
        worksheet.setColumnWidth(35, 6000);
        worksheet.setColumnWidth(36, 6000);
        worksheet.setColumnWidth(37, 6000);
        worksheet.setColumnWidth(49, 6000);
        worksheet.setColumnWidth(38, 6000);
        worksheet.setColumnWidth(39, 6000);
        worksheet.setColumnWidth(40, 6000);
        worksheet.setColumnWidth(50, 6000);
        worksheet.setColumnWidth(41, 6000);
        worksheet.setColumnWidth(42, 6000);
        worksheet.setColumnWidth(46, 6000);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Loan Type*");
        this.writeString(2, rowHeader, "Client/Group Name*");
        this.writeString(3, rowHeader, "Client ExternalID");
        this.writeString(4, rowHeader, "Product*");
        this.writeString(5, rowHeader, "Loan Officer*");
        this.writeString(6, rowHeader, "Submitted On*");
        this.writeString(7, rowHeader, "Approved On");
        this.writeString(8, rowHeader, "Disbursed Date");
        this.writeString(9, rowHeader, "Payment Type*");
        this.writeString(10, rowHeader, "Fund Name");
        this.writeString(11, rowHeader, "Principal*");
        this.writeString(15, rowHeader, "Loan Term*");
        this.writeString(12, rowHeader, "# of Repayments*");
        this.writeString(13, rowHeader, "Repaid Every*");
        this.writeString(17, rowHeader, "Nominal Interest %*");
        this.writeString(19, rowHeader, "Amortization*");
        this.writeString(20, rowHeader, "Interest Method*");
        this.writeString(21, rowHeader, "Interest Calculation Period*");
        this.writeString(22, rowHeader, "Arrears Tolerance");
        this.writeString(23, rowHeader, "Repayment Strategy*");
        this.writeString(24, rowHeader, "Grace-Principal Payment");
        this.writeString(25, rowHeader, "Grace-Interest Payment");
        this.writeString(26, rowHeader, "Interest-Free Period(s)");
        this.writeString(27, rowHeader, "Interest Charged From");
        this.writeString(28, rowHeader, "First Repayment On");
        this.writeString(29, rowHeader, "Amount Repaid");
        this.writeString(30, rowHeader, "Date-Last Repayment");
        this.writeString(31, rowHeader, "Repayment Type");
        this.writeString(43, rowHeader, "Client Name");
        this.writeString(44, rowHeader, "Lookup Client ExternalID");
        this.writeString(45, rowHeader, "Client Activation Date");
        this.writeString(35, rowHeader, "External Id");
        this.writeString(36, rowHeader, "Charge Name*");
        this.writeString(37, rowHeader, "Charged Amount");
        this.writeString(49, rowHeader, "Charged Amount Type");
        this.writeString(38, rowHeader, "Charged On Date");
        this.writeString(39, rowHeader, "Charge Name*");
        this.writeString(40, rowHeader, "Charged Amount");
        this.writeString(50, rowHeader, "Charged Amount Type");
        this.writeString(41, rowHeader, "Charged On Date");
        this.writeString(42, rowHeader, "GROUP ID");
        this.writeString(46, rowHeader, "Linked Account No.");
        CellStyle borderStyle = worksheet.getWorkbook().createCellStyle();
        CellStyle doubleBorderStyle = worksheet.getWorkbook().createCellStyle();
        borderStyle.setBorderBottom(BorderStyle.THIN);
        doubleBorderStyle.setBorderBottom(BorderStyle.THIN);
        doubleBorderStyle.setBorderRight(BorderStyle.THICK);
        for (int colNo = 0; colNo < 35; ++colNo) {
            Cell cell = rowHeader.getCell(colNo);
            if (cell == null) {
                rowHeader.createCell(colNo);
            }
            rowHeader.getCell(colNo).setCellStyle(borderStyle);
        }
        rowHeader.getCell(28).setCellStyle(doubleBorderStyle);
        rowHeader.getCell(31).setCellStyle(doubleBorderStyle);
    }

    private void setDefaults(Sheet worksheet) {
        Integer rowNo = 1;
        while (rowNo < 1000) {
            Row row = worksheet.createRow(rowNo.intValue());
            this.writeFormula(3, row, "IF(ISERROR(VLOOKUP($C" + (rowNo + 1) + ",$AR$2:$AS$" + (this.clientSheetPopulator.getClients().size() + 1) + ",2,FALSE)),\"\",(VLOOKUP($C" + (rowNo + 1) + ",$AR$2:$AS$" + (this.clientSheetPopulator.getClients().size() + 1) + ",2,FALSE)))");
            this.writeFormula(10, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"FUND_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"FUND_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(11, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"PRINCIPAL_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"PRINCIPAL_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(13, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"REPAYMENT_EVERY_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"REPAYMENT_EVERY_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(14, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"REPAYMENT_FREQUENCY_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"REPAYMENT_FREQUENCY_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(12, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"NO_REPAYMENT_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"NO_REPAYMENT_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(15, row, "IF(($O" + (rowNo + 1) + "=\"Semi Month\"), (IF(ISERROR($M" + (rowNo + 1) + "/$N" + (rowNo + 1) + "),\"\",$M" + (rowNo + 1) + "/$N" + (rowNo + 1) + ")), (IF(ISERROR($M" + (rowNo + 1) + "*$N" + (rowNo + 1) + "),\"\",$M" + (rowNo + 1) + "*$N" + (rowNo + 1) + ")))");
            this.writeFormula(16, row, "IF(($O" + (rowNo + 1) + "=\"Semi Month\"), \"Months\", $O" + (rowNo + 1) + ")");
            this.writeFormula(18, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"INTEREST_FREQUENCY_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"INTEREST_FREQUENCY_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(17, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"INTEREST_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"INTEREST_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(19, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"AMORTIZATION_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"AMORTIZATION_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(20, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"INTEREST_TYPE_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"INTEREST_TYPE_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(21, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"INTEREST_CALCULATION_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"INTEREST_CALCULATION_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(22, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"ARREARS_TOLERANCE_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"ARREARS_TOLERANCE_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(23, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"STRATEGY_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"STRATEGY_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(24, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"GRACE_PRINCIPAL_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"GRACE_PRINCIPAL_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(25, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"GRACE_INTEREST_PAYMENT_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"GRACE_INTEREST_PAYMENT_\",$E" + (rowNo + 1) + ")))");
            this.writeFormula(26, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"GRACE_INTEREST_CHARGED_\",$E" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"GRACE_INTEREST_CHARGED_\",$E" + (rowNo + 1) + ")))");
            Integer n = rowNo;
            rowNo = rowNo + 1;
        }
    }

    private void setNames(Sheet worksheet) {
        Workbook loanWorkbook = worksheet.getWorkbook();
        List officeNames = this.officeSheetPopulator.getOfficeNames();
        List charges = this.chargeSheetPopulator.getCharges();
        List products = this.productSheetPopulator.getProducts();
        Name officeGroup = loanWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (officeNames.size() + 1));
        Integer i = 0;
        while (i < officeNames.size()) {
            Object officeNameToBeginEndIndexesOfClients = (Integer[])this.clientSheetPopulator.getOfficeNameToBeginEndIndexesOfClients().get(i);
            Integer[] officeNameToBeginEndIndexesOfStaff = (Integer[])this.personnelSheetPopulator.getOfficeNameToBeginEndIndexesOfStaff().get(i);
            Integer[] officeNameToBeginEndIndexesOfGroups = (Integer[])this.groupSheetPopulator.getOfficeNameToBeginEndIndexesOfGroups().get(i);
            Name clientName = loanWorkbook.createName();
            Name loanOfficerName = loanWorkbook.createName();
            Name groupName = loanWorkbook.createName();
            if (officeNameToBeginEndIndexesOfStaff != null) {
                this.setSanitized(loanOfficerName, "Staff_" + (String)officeNames.get(i));
                loanOfficerName.setRefersToFormula("Staff!$B$" + officeNameToBeginEndIndexesOfStaff[0] + ":$B$" + officeNameToBeginEndIndexesOfStaff[1]);
            }
            if (officeNameToBeginEndIndexesOfClients != null) {
                this.setSanitized(clientName, "Client_" + (String)officeNames.get(i));
                clientName.setRefersToFormula("Clients!$B$" + officeNameToBeginEndIndexesOfClients[0] + ":$B$" + officeNameToBeginEndIndexesOfClients[1]);
            }
            if (officeNameToBeginEndIndexesOfGroups != null) {
                this.setSanitized(groupName, "Group_" + (String)officeNames.get(i));
                groupName.setRefersToFormula("Groups!$B$" + officeNameToBeginEndIndexesOfGroups[0] + ":$B$" + officeNameToBeginEndIndexesOfGroups[1]);
            }
            officeNameToBeginEndIndexesOfClients = i;
            i = i + 1;
        }
        Name productGroup = loanWorkbook.createName();
        productGroup.setNameName("Products");
        productGroup.setRefersToFormula("Products!$B$2:$B$" + (this.productSheetPopulator.getProductsSize() + 1));
        Name fundGroup = loanWorkbook.createName();
        fundGroup.setNameName("Funds");
        fundGroup.setRefersToFormula("Extras!$B$2:$B$" + (this.extrasSheetPopulator.getFundsSize() + 1));
        Name chargeGroup = loanWorkbook.createName();
        chargeGroup.setNameName("Charges");
        chargeGroup.setRefersToFormula("Charges!$B$2:$B$" + (this.chargeSheetPopulator.getChargesSize() + 1));
        Integer i2 = 0;
        while (i2 < charges.size()) {
            Object chargeColName = loanWorkbook.createName();
            Name chargeAmount = loanWorkbook.createName();
            Name chargeAmountType = loanWorkbook.createName();
            String chargeName = ((ChargeData)charges.get(i2)).getName().trim().replaceAll("[ )(]", "_");
            chargeColName.setNameName("CHARGE_NAME_" + chargeName);
            chargeColName.setRefersToFormula("Charges!$B$" + (i2 + 2));
            chargeAmount.setNameName("CHARGE_AMOUNT_" + chargeName);
            chargeAmount.setRefersToFormula("Charges!$C$" + (i2 + 2));
            chargeAmountType.setNameName("CHARGE_AMOUNT_TYPE_" + chargeName);
            chargeAmountType.setRefersToFormula("Charges!$D$" + (i2 + 2));
            chargeColName = i2;
            i2 = i2 + 1;
        }
        Name paymentTypeGroup = loanWorkbook.createName();
        paymentTypeGroup.setNameName("PaymentTypes");
        paymentTypeGroup.setRefersToFormula("Extras!$D$2:$D$" + (this.extrasSheetPopulator.getPaymentTypesSize() + 1));
        Integer i3 = 0;
        while (i3 < products.size()) {
            Name fundName = loanWorkbook.createName();
            Name principalName = loanWorkbook.createName();
            Name minPrincipalName = loanWorkbook.createName();
            Name maxPrincipalName = loanWorkbook.createName();
            Name noOfRepaymentName = loanWorkbook.createName();
            Name minNoOfRepayment = loanWorkbook.createName();
            Name maxNoOfRepaymentName = loanWorkbook.createName();
            Name repaymentEveryName = loanWorkbook.createName();
            Name repaymentFrequencyName = loanWorkbook.createName();
            Name interestName = loanWorkbook.createName();
            Name minInterestName = loanWorkbook.createName();
            Name maxInterestName = loanWorkbook.createName();
            Name interestFrequencyName = loanWorkbook.createName();
            Name amortizationName = loanWorkbook.createName();
            Name interestTypeName = loanWorkbook.createName();
            Name interestCalculationPeriodName = loanWorkbook.createName();
            Name transactionProcessingStrategyName = loanWorkbook.createName();
            Name arrearsToleranceName = loanWorkbook.createName();
            Name graceOnPrincipalPaymentName = loanWorkbook.createName();
            Name graceOnInterestPaymentName = loanWorkbook.createName();
            Name graceOnInterestChargedName = loanWorkbook.createName();
            Name startDateName = loanWorkbook.createName();
            String productName = ((LoanProductData)products.get(i3)).getName().replaceAll("[ ]", "_");
            this.setSanitized(fundName, "FUND_" + productName);
            this.setSanitized(principalName, "PRINCIPAL_" + productName);
            this.setSanitized(minPrincipalName, "MIN_PRINCIPAL_" + productName);
            this.setSanitized(maxPrincipalName, "MAX_PRINCIPAL_" + productName);
            this.setSanitized(noOfRepaymentName, "NO_REPAYMENT_" + productName);
            this.setSanitized(minNoOfRepayment, "MIN_REPAYMENT_" + productName);
            this.setSanitized(maxNoOfRepaymentName, "MAX_REPAYMENT_" + productName);
            this.setSanitized(repaymentEveryName, "REPAYMENT_EVERY_" + productName);
            this.setSanitized(repaymentFrequencyName, "REPAYMENT_FREQUENCY_" + productName);
            this.setSanitized(interestName, "INTEREST_" + productName);
            this.setSanitized(minInterestName, "MIN_INTEREST_" + productName);
            this.setSanitized(maxInterestName, "MAX_INTEREST_" + productName);
            this.setSanitized(interestFrequencyName, "INTEREST_FREQUENCY_" + productName);
            this.setSanitized(amortizationName, "AMORTIZATION_" + productName);
            this.setSanitized(interestTypeName, "INTEREST_TYPE_" + productName);
            this.setSanitized(interestCalculationPeriodName, "INTEREST_CALCULATION_" + productName);
            this.setSanitized(transactionProcessingStrategyName, "STRATEGY_" + productName);
            this.setSanitized(arrearsToleranceName, "ARREARS_TOLERANCE_" + productName);
            this.setSanitized(graceOnPrincipalPaymentName, "GRACE_PRINCIPAL_" + productName);
            this.setSanitized(graceOnInterestPaymentName, "GRACE_INTEREST_PAYMENT_" + productName);
            this.setSanitized(graceOnInterestChargedName, "GRACE_INTEREST_CHARGED_" + productName);
            this.setSanitized(startDateName, "START_DATE_" + productName);
            if (((LoanProductData)products.get(i3)).getFundName() != null) {
                fundName.setRefersToFormula("Products!$C$" + (i3 + 2));
            }
            principalName.setRefersToFormula("Products!$D$" + (i3 + 2));
            minPrincipalName.setRefersToFormula("Products!$E$" + (i3 + 2));
            maxPrincipalName.setRefersToFormula("Products!$F$" + (i3 + 2));
            noOfRepaymentName.setRefersToFormula("Products!$G$" + (i3 + 2));
            minNoOfRepayment.setRefersToFormula("Products!$H$" + (i3 + 2));
            maxNoOfRepaymentName.setRefersToFormula("Products!$I$" + (i3 + 2));
            repaymentEveryName.setRefersToFormula("Products!$J$" + (i3 + 2));
            repaymentFrequencyName.setRefersToFormula("Products!$K$" + (i3 + 2));
            interestName.setRefersToFormula("Products!$L$" + (i3 + 2));
            minInterestName.setRefersToFormula("Products!$M$" + (i3 + 2));
            maxInterestName.setRefersToFormula("Products!$N$" + (i3 + 2));
            interestFrequencyName.setRefersToFormula("Products!$O$" + (i3 + 2));
            amortizationName.setRefersToFormula("Products!$P$" + (i3 + 2));
            interestTypeName.setRefersToFormula("Products!$Q$" + (i3 + 2));
            interestCalculationPeriodName.setRefersToFormula("Products!$R$" + (i3 + 2));
            transactionProcessingStrategyName.setRefersToFormula("Products!$T$" + (i3 + 2));
            arrearsToleranceName.setRefersToFormula("Products!$S$" + (i3 + 2));
            graceOnPrincipalPaymentName.setRefersToFormula("Products!$U$" + (i3 + 2));
            graceOnInterestPaymentName.setRefersToFormula("Products!$V$" + (i3 + 2));
            graceOnInterestChargedName.setRefersToFormula("Products!$W$" + (i3 + 2));
            startDateName.setRefersToFormula("Products!$X$" + (i3 + 2));
            Integer n = i3;
            i3 = i3 + 1;
        }
    }
}

