/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.service;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailData;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageStatusType;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailNotFoundException;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailReadPlatformService;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class EmailReadPlatformServiceImpl
implements EmailReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final EmailMapper emailRowMapper = new EmailMapper();
    private final PaginationHelper paginationHelper;

    public Collection<EmailData> retrieveAll() {
        String sql = "select " + this.emailRowMapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailRowMapper);
    }

    public EmailData retrieveOne(Long resourceId) {
        try {
            String sql = "select " + this.emailRowMapper.schema() + " where emo.id = ?";
            return (EmailData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.emailRowMapper, new Object[]{resourceId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmailNotFoundException(resourceId, e);
        }
    }

    public Collection<EmailData> retrieveAllPending(SearchParameters searchParameters) {
        String sqlPlusLimit = searchParameters.getLimit() > 0 ? " " + this.sqlGenerator.limit(searchParameters.getLimit().intValue()) : "";
        String sql = "select " + this.emailRowMapper.schema() + " where emo.status_enum =? " + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailRowMapper, new Object[]{EmailMessageStatusType.PENDING.getValue()});
    }

    public Collection<EmailData> retrieveAllSent(SearchParameters searchParameters) {
        String sqlPlusLimit = searchParameters.getLimit() > 0 ? " " + this.sqlGenerator.limit(searchParameters.getLimit().intValue()) : "";
        String sql = "select " + this.emailRowMapper.schema() + " where emo.status_enum = ?" + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailRowMapper, new Object[]{EmailMessageStatusType.SENT.getValue()});
    }

    public List<Long> retrieveExternalIdsOfAllSent(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select external_id from " + this.emailRowMapper.tableName() + " where status_enum =? " + sqlPlusLimit;
        return this.jdbcTemplate.queryForList(sql, Long.class, new Object[]{EmailMessageStatusType.SENT.getValue()});
    }

    public Collection<EmailData> retrieveAllDelivered(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select " + this.emailRowMapper.schema() + " where emo.status_enum = ?" + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailRowMapper, new Object[]{EmailMessageStatusType.DELIVERED.getValue()});
    }

    public Collection<EmailData> retrieveAllFailed(SearchParameters searchParameters) {
        String sqlPlusLimit = searchParameters.getLimit() > 0 ? " " + this.sqlGenerator.limit(searchParameters.getLimit().intValue()) : "";
        String sql = "select " + this.emailRowMapper.schema() + " where emo.status_enum = ?" + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailRowMapper, new Object[]{EmailMessageStatusType.FAILED.getValue()});
    }

    public Page<EmailData> retrieveEmailByStatus(Integer limit, Integer status, LocalDate dateFrom, LocalDate dateTo) {
        String sqlPlusLimit;
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.emailRowMapper.schema());
        if (status != null) {
            sqlBuilder.append(" where emo.status_enum= ? ");
        }
        String fromDateString = null;
        String toDateString = null;
        if (dateFrom != null && dateTo != null) {
            fromDateString = DateUtils.DEFAULT_DATE_FORMATTER.format(dateFrom);
            toDateString = DateUtils.DEFAULT_DATE_FORMATTER.format(dateTo);
            sqlBuilder.append(" and emo.submittedon_date >= ? and emo.submittedon_date <= ? ");
        }
        String string = sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        if (!sqlPlusLimit.isEmpty()) {
            sqlBuilder.append(sqlPlusLimit);
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), new Object[]{status, fromDateString, toDateString}, (RowMapper)this.emailRowMapper);
    }

    @Generated
    public EmailReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.paginationHelper = paginationHelper;
    }
}

