/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.updateemailoutboundwithcampaignmessage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailCampaignData;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaign;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessage;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageRepository;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailCampaignNotFound;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignReadPlatformService;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignWritePlatformService;
import org.apache.fineract.infrastructure.campaigns.jobs.updateemailoutboundwithcampaignmessage.EmailParamMappingException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class UpdateEmailOutboundWithCampaignMessageTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateEmailOutboundWithCampaignMessageTasklet.class);
    private final EmailCampaignReadPlatformService emailCampaignReadPlatformService;
    private final EmailCampaignRepository emailCampaignRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final EmailMessageRepository emailMessageRepository;
    private final EmailCampaignWritePlatformService emailCampaignWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection emailCampaignDataCollection = this.emailCampaignReadPlatformService.retrieveAllScheduleActiveCampaign();
        if (emailCampaignDataCollection != null) {
            for (EmailCampaignData emailCampaignData : emailCampaignDataCollection) {
                LocalDateTime tenantDateNow = DateUtils.getLocalDateTimeOfTenant();
                LocalDateTime nextTriggerDate = emailCampaignData.getNextTriggerDate().toLocalDateTime();
                log.debug("tenant time {} trigger time {}", (Object)tenantDateNow, (Object)nextTriggerDate);
                if (!DateUtils.isBefore((LocalDateTime)nextTriggerDate, (LocalDateTime)tenantDateNow)) continue;
                this.insertDirectCampaignIntoEmailOutboundTable(emailCampaignData.getParamValue(), emailCampaignData.getEmailSubject(), emailCampaignData.getEmailMessage(), emailCampaignData.getCampaignName(), emailCampaignData.getId());
                this.updateTriggerDates(emailCampaignData.getId());
            }
        }
        return RepeatStatus.FINISHED;
    }

    private void insertDirectCampaignIntoEmailOutboundTable(String emailParams, String emailSubject, String messageTemplate, String campaignName, Long campaignId) {
        try {
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(emailParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(emailParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List runReportObject = this.emailCampaignWritePlatformService.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
            if (runReportObject != null) {
                for (HashMap entry : runReportObject) {
                    String message = this.compileEmailTemplate(messageTemplate, campaignName, (Map)entry);
                    Integer clientId = (Integer)entry.get("id");
                    EmailCampaign emailCampaign = this.emailCampaignRepository.findById((Object)campaignId).orElse(null);
                    Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(Long.valueOf(clientId.longValue()));
                    String emailAddress = client.emailAddress();
                    if (emailAddress == null || !UpdateEmailOutboundWithCampaignMessageTasklet.isValidEmail((String)emailAddress)) continue;
                    EmailMessage emailMessage = EmailMessage.pendingEmail(null, (Client)client, null, (EmailCampaign)emailCampaign, (String)emailSubject, (String)message, (String)emailAddress, (String)campaignName);
                    this.emailMessageRepository.save((Object)emailMessage);
                }
            }
        }
        catch (IOException e) {
            throw new EmailParamMappingException((Exception)e);
        }
    }

    private void updateTriggerDates(Long campaignId) {
        EmailCampaign emailCampaign = (EmailCampaign)this.emailCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new EmailCampaignNotFound(campaignId));
        LocalDateTime nextTriggerDate = emailCampaign.getNextTriggerDate();
        emailCampaign.setLastTriggerDate(nextTriggerDate);
        LocalDateTime newTriggerDateWithTime = CalendarUtils.getNextRecurringDate((String)emailCampaign.getRecurrence(), (LocalDateTime)nextTriggerDate, (LocalDateTime)nextTriggerDate);
        LocalDateTime tenantDateTime = DateUtils.getLocalDateTimeOfTenant();
        if (DateUtils.isBefore((LocalDateTime)newTriggerDateWithTime, (LocalDateTime)tenantDateTime)) {
            newTriggerDateWithTime = CalendarUtils.getNextRecurringDate((String)emailCampaign.getRecurrence(), (LocalDateTime)nextTriggerDate, (LocalDateTime)tenantDateTime);
        }
        emailCampaign.setNextTriggerDate(newTriggerDateWithTime);
        this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
    }

    private String compileEmailTemplate(String textMessageTemplate, String campaignName, Map<String, Object> emailParams) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader(textMessageTemplate), campaignName);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, emailParams);
        return stringWriter.toString();
    }

    public static boolean isValidEmail(String email) {
        boolean isValid = true;
        try {
            InternetAddress emailO = new InternetAddress(email);
            emailO.validate();
        }
        catch (AddressException ex) {
            isValid = false;
        }
        return isValid;
    }

    @Generated
    public UpdateEmailOutboundWithCampaignMessageTasklet(EmailCampaignReadPlatformService emailCampaignReadPlatformService, EmailCampaignRepository emailCampaignRepository, ClientRepositoryWrapper clientRepositoryWrapper, EmailMessageRepository emailMessageRepository, EmailCampaignWritePlatformService emailCampaignWritePlatformService) {
        this.emailCampaignReadPlatformService = emailCampaignReadPlatformService;
        this.emailCampaignRepository = emailCampaignRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.emailMessageRepository = emailMessageRepository;
        this.emailCampaignWritePlatformService = emailCampaignWritePlatformService;
    }
}

