/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.handler;

import lombok.Generated;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableReadService;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableWriteService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegisterDatatableCommandHandler
implements NewCommandSourceHandler {
    private final DatatableWriteService datatableWriteService;
    private final DatatableReadService datatableReadService;

    @Transactional
    public CommandProcessingResult processCommand(JsonCommand command) {
        this.datatableWriteService.registerDatatable(command);
        return new CommandProcessingResultBuilder().withResourceIdAsString(this.datatableReadService.getDataTableName(command.getUrl())).build();
    }

    @Generated
    public RegisterDatatableCommandHandler(DatatableWriteService datatableWriteService, DatatableReadService datatableReadService) {
        this.datatableWriteService = datatableWriteService;
        this.datatableReadService = datatableReadService;
    }
}

