/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.producer.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.diagnostics.performance.MeasuringUtil;
import org.apache.fineract.infrastructure.event.external.exception.AcknowledgementTimeoutException;
import org.apache.fineract.infrastructure.event.external.producer.ExternalEventProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"fineract.events.external.producer.kafka.enabled"}, havingValue="true")
public class KafkaExternalEventProducer
implements ExternalEventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaExternalEventProducer.class);
    @Autowired
    private KafkaTemplate<Long, byte[]> externalEventsKafkaTemplate;
    @Autowired
    private FineractProperties fineractProperties;

    public void sendEvents(Map<Long, List<byte[]>> partitions) throws AcknowledgementTimeoutException {
        FineractProperties.FineractExternalEventsProducerKafkaProperties kafkaProperties = this.fineractProperties.getEvents().getExternal().getProducer().getKafka();
        String topicName = kafkaProperties.getTopic().getName();
        ArrayList sendResults = new ArrayList();
        MeasuringUtil.measure(() -> {
            Set keys = partitions.keySet();
            for (Map.Entry entry : partitions.entrySet()) {
                for (byte[] message : (List)entry.getValue()) {
                    sendResults.add(this.externalEventsKafkaTemplate.send(topicName, (Object)((Long)entry.getKey()), (Object)message));
                }
            }
            try {
                CompletableFuture<Void> allOf = CompletableFuture.allOf(sendResults.toArray(new CompletableFuture[0]));
                allOf.get(kafkaProperties.getTimeoutInSeconds(), TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not send the messages", exception);
            }
        }, timeTaken -> {
            if (log.isDebugEnabled()) {
                int eventCount = partitions.values().stream().map(Collection::size).reduce(0, Integer::sum);
                int msgPerSec = (int)((double)eventCount / (double)timeTaken.toMillis() * 1000.0);
                log.debug("Sent messages with {} msg/s", (Object)msgPerSec);
            }
        });
    }

    @Generated
    public KafkaExternalEventProducer(KafkaTemplate<Long, byte[]> externalEventsKafkaTemplate, FineractProperties fineractProperties) {
        this.externalEventsKafkaTemplate = externalEventsKafkaTemplate;
        this.fineractProperties = fineractProperties;
    }
}

