/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.domain;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.springframework.batch.core.BatchStatus;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class JobExecutionRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final FineractProperties fineractProperties;
    private final DatabaseTypeResolver databaseTypeResolver;

    public List<String> getStuckJobNames(NamedParameterJdbcTemplate jdbcTemplate) {
        int threshold = this.fineractProperties.getJob().getStuckRetryThreshold();
        return jdbcTemplate.queryForList("SELECT DISTINCT(BJI.JOB_NAME) as STUCK_JOB_NAME\nFROM BATCH_JOB_INSTANCE BJI\nINNER JOIN BATCH_JOB_EXECUTION BJE\nON BJI.JOB_INSTANCE_ID = BJE.JOB_INSTANCE_ID\nWHERE\n    BJE.STATUS IN (:statuses)\n    AND\n    BJE.JOB_INSTANCE_ID NOT IN (\n        SELECT IBJE.JOB_INSTANCE_ID\n        FROM BATCH_JOB_INSTANCE IBJI\n        INNER JOIN BATCH_JOB_EXECUTION IBJE\n        ON IBJI.JOB_INSTANCE_ID = IBJE.JOB_INSTANCE_ID\n        WHERE IBJE.STATUS IN (:completedStatuses)\n    )\nGROUP BY BJI.JOB_INSTANCE_ID\nHAVING COUNT(BJI.JOB_INSTANCE_ID) <= :threshold\n", Map.of("statuses", List.of(BatchStatus.STARTED.name()), "completedStatuses", List.of(BatchStatus.COMPLETED.name(), BatchStatus.FAILED.name(), BatchStatus.UNKNOWN.name()), "threshold", threshold), String.class);
    }

    public Long getStuckJobCountByJobName(String jobName) {
        int threshold = this.fineractProperties.getJob().getStuckRetryThreshold();
        return (Long)this.namedParameterJdbcTemplate.queryForObject("    SELECT COUNT(DISTINCT BJI.JOB_NAME) as STUCK_JOB_COUNT\n    FROM BATCH_JOB_INSTANCE BJI\n    INNER JOIN BATCH_JOB_EXECUTION BJE\n    ON BJI.JOB_INSTANCE_ID = BJE.JOB_INSTANCE_ID\n    WHERE\n        BJE.STATUS IN (:statuses)\n        AND\n        BJI.JOB_NAME = :jobName\n        AND\n        BJE.JOB_INSTANCE_ID NOT IN (\n            SELECT IBJE.JOB_INSTANCE_ID\n            FROM BATCH_JOB_INSTANCE IBJI\n            INNER JOIN BATCH_JOB_EXECUTION IBJE\n            ON IBJI.JOB_INSTANCE_ID = IBJE.JOB_INSTANCE_ID\n            WHERE\n                IBJE.STATUS IN (:completedStatuses)\n                AND\n                IBJI.JOB_NAME = :jobName\n        )\n    GROUP BY BJI.JOB_INSTANCE_ID\n    HAVING COUNT(BJI.JOB_INSTANCE_ID) <= :threshold\n", Map.of("statuses", List.of(BatchStatus.STARTED.name()), "jobName", jobName, "completedStatuses", List.of(BatchStatus.COMPLETED.name(), BatchStatus.FAILED.name(), BatchStatus.UNKNOWN.name()), "threshold", threshold), Long.class);
    }

    public List<Long> getStuckJobIdsByJobName(String jobName) {
        int threshold = this.fineractProperties.getJob().getStuckRetryThreshold();
        return this.namedParameterJdbcTemplate.queryForList("    SELECT BJE.JOB_EXECUTION_ID\n    FROM BATCH_JOB_INSTANCE BJI\n    INNER JOIN BATCH_JOB_EXECUTION BJE\n    ON BJI.JOB_INSTANCE_ID = BJE.JOB_INSTANCE_ID\n    WHERE\n        BJE.STATUS IN (:statuses)\n        AND\n        BJI.JOB_NAME = :jobName\n        AND\n        BJE.JOB_INSTANCE_ID NOT IN (\n            SELECT IBJE.JOB_INSTANCE_ID\n            FROM BATCH_JOB_INSTANCE IBJI\n            INNER JOIN BATCH_JOB_EXECUTION IBJE\n            ON IBJI.JOB_INSTANCE_ID = IBJE.JOB_INSTANCE_ID\n            WHERE\n            IBJE.STATUS IN (:completedStatuses)\n            AND\n            IBJI.JOB_NAME = :jobName\n        )\n    GROUP BY BJI.JOB_INSTANCE_ID, BJE.JOB_EXECUTION_ID\n    HAVING COUNT(BJI.JOB_INSTANCE_ID) <= :threshold\n", Map.of("statuses", List.of(BatchStatus.STARTED.name()), "jobName", jobName, "completedStatuses", List.of(BatchStatus.COMPLETED.name(), BatchStatus.FAILED.name(), BatchStatus.UNKNOWN.name()), "threshold", threshold), Long.class);
    }

    public Long getNotCompletedPartitionsCount(Long jobExecutionId, String partitionerStepName) {
        return (Long)this.namedParameterJdbcTemplate.queryForObject("    SELECT COUNT(BSE.STEP_EXECUTION_ID)\n    FROM BATCH_STEP_EXECUTION BSE\n    WHERE\n        BSE.JOB_EXECUTION_ID = :jobExecutionId\n        AND\n        BSE.STEP_NAME <> :stepName\n        AND\n        BSE.status <> :status\n", Map.of("jobExecutionId", jobExecutionId, "stepName", partitionerStepName, "status", BatchStatus.COMPLETED.name()), Long.class);
    }

    public void updateJobStatusToFailed(Long stuckJobId, String partitionerStepName) {
        this.namedParameterJdbcTemplate.update("    UPDATE BATCH_STEP_EXECUTION\n    SET STATUS = :status\n    WHERE\n        JOB_EXECUTION_ID = :jobExecutionId\n        AND\n        STEP_NAME = :stepName\n", Map.of("status", BatchStatus.FAILED.name(), "jobExecutionId", stuckJobId, "stepName", partitionerStepName));
        this.namedParameterJdbcTemplate.update("    UPDATE BATCH_JOB_EXECUTION\n    SET\n        STATUS = :status,\n        START_TIME = null,\n        END_TIME = null\n    WHERE\n        JOB_EXECUTION_ID = :jobExecutionId\n", Map.of("status", BatchStatus.FAILED.name(), "jobExecutionId", stuckJobId));
    }

    public LocalDate getBusinessDateOfRunningJobByExecutionParameter(String jobName, String jobCustomParamKeyName, String parameterKeyName, String parameterValue, String dateParameterName) {
        try {
            if (this.databaseTypeResolver.isPostgreSQL()) {
                return (LocalDate)this.namedParameterJdbcTemplate.queryForObject("SELECT\n        J2->>'parameterValue'\nFROM\n    BATCH_JOB_INSTANCE BJI\n        INNER JOIN BATCH_JOB_EXECUTION BJE ON BJI.JOB_INSTANCE_ID = BJE.JOB_INSTANCE_ID\n        INNER JOIN BATCH_JOB_EXECUTION_PARAMS BJEP ON BJE.JOB_EXECUTION_ID = BJEP.JOB_EXECUTION_ID\n        inner join batch_custom_job_parameters CJP ON cast(BJEP.parameter_value as bigint) = CJP.id\n        AND BJEP.parameter_name = :jobCustomParamKeyName\n        CROSS JOIN LATERAL json_array_elements(CJP.parameter_json) J\n        CROSS JOIN LATERAL json_array_elements(CJP.parameter_json) J2\nWHERE\n            J ->> 'parameterName' = :filterParameterName\n  AND J ->> 'parameterValue' = :filterParameterValue\n  AND J2 ->> 'parameterName' = :dateParameterName\n  AND BJE.STATUS IN (:statuses)\n  AND BJI.JOB_NAME = :jobName\n  AND BJE.JOB_INSTANCE_ID NOT IN (\n    SELECT\n        IBJE.JOB_INSTANCE_ID\n    FROM\n        BATCH_JOB_INSTANCE IBJI\n            INNER JOIN BATCH_JOB_EXECUTION IBJE ON IBJI.JOB_INSTANCE_ID = IBJE.JOB_INSTANCE_ID\n    WHERE\n            IBJE.STATUS = :completedStatus\n      AND IBJI.JOB_NAME = :jobName)\n", Map.of("jobCustomParamKeyName", jobCustomParamKeyName, "filterParameterName", parameterKeyName, "filterParameterValue", parameterValue, "statuses", List.of(BatchStatus.STARTED.name(), BatchStatus.STARTING.name()), "completedStatus", BatchStatus.COMPLETED.name(), "jobName", jobName, "dateParameterName", dateParameterName), LocalDate.class);
            }
            if (this.databaseTypeResolver.isMySQL()) {
                return (LocalDate)this.namedParameterJdbcTemplate.queryForObject("SELECT\n     J2.parameter_value\nFROM\n    BATCH_JOB_INSTANCE BJI\n        INNER JOIN BATCH_JOB_EXECUTION BJE ON BJI.JOB_INSTANCE_ID = BJE.JOB_INSTANCE_ID\n        INNER JOIN BATCH_JOB_EXECUTION_PARAMS BJEP ON BJE.JOB_EXECUTION_ID = BJEP.JOB_EXECUTION_ID\n        inner join batch_custom_job_parameters CJP ON BJEP.parameter_value = CJP.id\n        AND BJEP.parameter_name = :jobCustomParamKeyName\n        CROSS JOIN json_table(CJP.parameter_json, '$[*]' COLUMNS(parameter_name VARCHAR(100) PATH \"$.parameterName\", parameter_value VARCHAR(100) PATH \"$.parameterValue\")) J\n        CROSS JOIN json_table(CJP.parameter_json, '$[*]' COLUMNS(parameter_name VARCHAR(100) PATH \"$.parameterName\", parameter_value VARCHAR(100) PATH \"$.parameterValue\")) J2\nWHERE\n        J.parameter_name = :filterParameterName\n  AND J.parameter_value = :filterParameterValue\n  AND J2.parameter_name = :dateParameterName\n  AND BJE.STATUS IN (:statuses)\n  AND BJI.JOB_NAME = :jobName\n  AND BJE.JOB_INSTANCE_ID NOT IN (\n    SELECT\n        IBJE.JOB_INSTANCE_ID\n    FROM\n        BATCH_JOB_INSTANCE IBJI\n            INNER JOIN BATCH_JOB_EXECUTION IBJE ON IBJI.JOB_INSTANCE_ID = IBJE.JOB_INSTANCE_ID\n    WHERE\n            IBJE.STATUS = :completedStatus\n      AND IBJI.JOB_NAME = :jobName);\n", Map.of("jobCustomParamKeyName", jobCustomParamKeyName, "filterParameterName", parameterKeyName, "filterParameterValue", parameterValue, "dateParameterName", dateParameterName, "statuses", List.of(BatchStatus.STARTED.name(), BatchStatus.STARTING.name()), "jobName", jobName, "completedStatus", BatchStatus.COMPLETED.name()), LocalDate.class);
            }
            throw new IllegalStateException("Database type is not supported for json query " + String.valueOf(this.databaseTypeResolver.databaseType()));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Generated
    public JobExecutionRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate, FineractProperties fineractProperties, DatabaseTypeResolver databaseTypeResolver) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.fineractProperties = fineractProperties;
        this.databaseTypeResolver = databaseTypeResolver;
    }
}

