/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.validation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.reportmailingjob.ReportMailingJobConstants;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobEmailAttachmentFileFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportMailingJobValidator {
    private final FromJsonHelper fromJsonHelper;
    private static final String EMAIL_REGEX = "^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$");

    @Autowired
    public ReportMailingJobValidator(FromJsonHelper fromJsonHelper) {
        this.fromJsonHelper = fromJsonHelper;
    }

    public void validateCreateRequest(JsonCommand jsonCommand) {
        String jsonString = jsonCommand.json();
        JsonElement jsonElement = jsonCommand.parsedJson();
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            throw new InvalidJsonException();
        }
        Type typeToken = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromJsonHelper.checkForUnsupportedParameters(typeToken, jsonString, (Collection)ReportMailingJobConstants.CREATE_REQUEST_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder dataValidatorBuilder = new DataValidatorBuilder(dataValidationErrors).resource(StringUtils.lowerCase((String)"reportmailingjobs"));
        String name = this.fromJsonHelper.extractStringNamed("name", jsonElement);
        dataValidatorBuilder.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String startDateTime = this.fromJsonHelper.extractStringNamed("startDateTime", jsonElement);
        dataValidatorBuilder.reset().parameter("startDateTime").value((Object)startDateTime).notBlank();
        Integer stretchyReportId = this.fromJsonHelper.extractIntegerWithLocaleNamed("stretchyReportId", jsonElement);
        dataValidatorBuilder.reset().parameter("stretchyReportId").value((Object)stretchyReportId).notNull().integerGreaterThanZero();
        String emailRecipients = this.fromJsonHelper.extractStringNamed("emailRecipients", jsonElement);
        dataValidatorBuilder.reset().parameter("emailRecipients").value((Object)emailRecipients).notBlank();
        String emailSubject = this.fromJsonHelper.extractStringNamed("emailSubject", jsonElement);
        dataValidatorBuilder.reset().parameter("emailSubject").value((Object)emailSubject).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String emailMessage = this.fromJsonHelper.extractStringNamed("emailMessage", jsonElement);
        dataValidatorBuilder.reset().parameter("emailMessage").value((Object)emailMessage).notBlank();
        if (this.fromJsonHelper.parameterExists("isActive", jsonElement)) {
            Boolean isActive = this.fromJsonHelper.extractBooleanNamed("isActive", jsonElement);
            dataValidatorBuilder.reset().parameter("isActive").value((Object)isActive).notNull();
        }
        Integer emailAttachmentFileFormatId = this.fromJsonHelper.extractIntegerSansLocaleNamed("emailAttachmentFileFormatId", jsonElement);
        dataValidatorBuilder.reset().parameter("emailAttachmentFileFormatId").value((Object)emailAttachmentFileFormatId).notNull();
        if (emailAttachmentFileFormatId != null) {
            dataValidatorBuilder.reset().parameter("emailAttachmentFileFormatId").value((Object)emailAttachmentFileFormatId).isOneOfTheseValues(ReportMailingJobEmailAttachmentFileFormat.validIds());
        }
        String dateFormat = jsonCommand.dateFormat();
        dataValidatorBuilder.reset().parameter("dateFormat").value((Object)dateFormat).notBlank();
        if (StringUtils.isNotEmpty((CharSequence)dateFormat)) {
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat).withLocale(jsonCommand.extractLocale());
                LocalDateTime.parse(startDateTime, dateTimeFormatter);
            }
            catch (IllegalArgumentException ex) {
                dataValidatorBuilder.reset().parameter("dateFormat").value((Object)dateFormat).failWithCode("invalid.date.format", new Object[0]);
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateUpdateRequest(JsonCommand jsonCommand) {
        String jsonString = jsonCommand.json();
        JsonElement jsonElement = jsonCommand.parsedJson();
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            throw new InvalidJsonException();
        }
        Type typeToken = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromJsonHelper.checkForUnsupportedParameters(typeToken, jsonString, (Collection)ReportMailingJobConstants.UPDATE_REQUEST_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder dataValidatorBuilder = new DataValidatorBuilder(dataValidationErrors).resource(StringUtils.lowerCase((String)"reportmailingjobs"));
        if (this.fromJsonHelper.parameterExists("name", jsonElement)) {
            String name = this.fromJsonHelper.extractStringNamed("name", jsonElement);
            dataValidatorBuilder.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromJsonHelper.parameterExists("stretchyReportId", jsonElement)) {
            Integer stretchyReportId = this.fromJsonHelper.extractIntegerWithLocaleNamed("stretchyReportId", jsonElement);
            dataValidatorBuilder.reset().parameter("stretchyReportId").value((Object)stretchyReportId).notNull().integerGreaterThanZero();
        }
        if (this.fromJsonHelper.parameterExists("emailRecipients", jsonElement)) {
            String emailRecipients = this.fromJsonHelper.extractStringNamed("emailRecipients", jsonElement);
            dataValidatorBuilder.reset().parameter("emailRecipients").value((Object)emailRecipients).notBlank();
        }
        if (this.fromJsonHelper.parameterExists("emailSubject", jsonElement)) {
            String emailSubject = this.fromJsonHelper.extractStringNamed("emailSubject", jsonElement);
            dataValidatorBuilder.reset().parameter("emailSubject").value((Object)emailSubject).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromJsonHelper.parameterExists("emailMessage", jsonElement)) {
            String emailMessage = this.fromJsonHelper.extractStringNamed("emailMessage", jsonElement);
            dataValidatorBuilder.reset().parameter("emailMessage").value((Object)emailMessage).notBlank();
        }
        if (this.fromJsonHelper.parameterExists("isActive", jsonElement)) {
            Boolean isActive = this.fromJsonHelper.extractBooleanNamed("isActive", jsonElement);
            dataValidatorBuilder.reset().parameter("isActive").value((Object)isActive).notNull();
        }
        if (this.fromJsonHelper.parameterExists("emailAttachmentFileFormatId", jsonElement)) {
            Integer emailAttachmentFileFormatId = this.fromJsonHelper.extractIntegerSansLocaleNamed("emailAttachmentFileFormatId", jsonElement);
            dataValidatorBuilder.reset().parameter("emailAttachmentFileFormatId").value((Object)emailAttachmentFileFormatId).notNull();
            if (emailAttachmentFileFormatId != null) {
                dataValidatorBuilder.reset().parameter("emailAttachmentFileFormatId").value((Object)emailAttachmentFileFormatId).isOneOfTheseValues(ReportMailingJobEmailAttachmentFileFormat.validIds());
            }
        }
        if (this.fromJsonHelper.parameterExists("startDateTime", jsonElement)) {
            String dateFormat = jsonCommand.dateFormat();
            dataValidatorBuilder.reset().parameter("dateFormat").value((Object)dateFormat).notBlank();
            String startDateTime = this.fromJsonHelper.extractStringNamed("startDateTime", jsonElement);
            dataValidatorBuilder.reset().parameter("startDateTime").value((Object)startDateTime).notBlank();
            if (StringUtils.isNotEmpty((CharSequence)dateFormat)) {
                try {
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat).withLocale(jsonCommand.extractLocale());
                    LocalDateTime.parse(startDateTime, dateTimeFormatter);
                }
                catch (IllegalArgumentException ex) {
                    dataValidatorBuilder.reset().parameter("dateFormat").value((Object)dateFormat).failWithCode("invalid.date.format", new Object[0]);
                }
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        if (email.endsWith(".")) {
            return false;
        }
        Matcher emailMatcher = EMAIL_PATTERN.matcher(email);
        return emailMatcher.matches();
    }

    public Set<String> validateEmailRecipients(String emailRecipients) {
        HashSet<String> emailRecipientsSet = new HashSet<String>();
        if (emailRecipients != null) {
            Iterable split = Splitter.on((char)',').split((CharSequence)emailRecipients);
            for (String emailAddress : split) {
                if (!this.isValidEmail(emailAddress = emailAddress.trim())) continue;
                emailRecipientsSet.add(emailAddress);
            }
        }
        return emailRecipientsSet;
    }

    public HashMap<String, String> validateStretchyReportParamMap(String stretchyReportParamMap) {
        HashMap stretchyReportParamHashMap = new HashMap();
        if (!StringUtils.isEmpty((CharSequence)stretchyReportParamMap)) {
            try {
                stretchyReportParamHashMap = (HashMap)new ObjectMapper().readValue(stretchyReportParamMap, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                stretchyReportParamHashMap = null;
            }
        }
        return stretchyReportParamHashMap;
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

