/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler.kafka;

import java.util.HashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.springbatch.messagehandler.conditions.kafka.KafkaWorkerCondition;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.serializer.JsonDeserializer;

@Configuration
@Conditional(value={KafkaWorkerCondition.class})
public class KafkaWorkerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaWorkerConfig.class);
    @Autowired
    private QueueChannel inboundRequests;
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    public ConsumerFactory<Integer, Object> consumerFactory() {
        FineractProperties.FineractRemoteJobMessageHandlerKafkaProperties kafkaProperties = this.fineractProperties.getRemoteJobMessageHandler().getKafka();
        HashMap<String, Object> props = new HashMap<String, Object>(kafkaProperties.getConsumer().getExtraPropertiesMap());
        props.put("bootstrap.servers", kafkaProperties.getBootstrapServers());
        props.put("group.id", kafkaProperties.getConsumer().getGroupId());
        props.put("key.deserializer", IntegerDeserializer.class);
        props.put("value.deserializer", JsonDeserializer.class);
        props.put("spring.json.trusted.packages", "*");
        props.put("auto.offset.reset", "earliest");
        return new DefaultKafkaConsumerFactory(props);
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<Integer, Object> kafkaListenerContainerFactory(ConsumerFactory<Integer, Object> consumerFactory) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(consumerFactory);
        factory.getContainerProperties().setAckMode(ContainerProperties.AckMode.MANUAL);
        return factory;
    }
}

