/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.api;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.organisation.office.api.OfficeSwaggerMapper;
import org.apache.fineract.organisation.office.api.OfficesApiResourceSwagger;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/offices")
@Component
@Tag(name="Offices", description="Offices are used to model an MFIs structure. A hierarchical representation of offices is supported. There will always be at least one office (which represents the MFI or an MFIs head office). All subsequent offices added must have a parent office.")
public class OfficesApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(List.of("id", "name", "nameDecorated", "externalId", "openingDate", "hierarchy", "parentId", "parentName", "allowedParents"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "OFFICE";
    private final OfficeSwaggerMapper officeSwaggerMapper;
    private final PlatformSecurityContext context;
    private final OfficeReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<OfficeData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final SqlValidator sqlValidator;
    private final Gson gson = GoogleGsonSerializerHelper.createSimpleGson();

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Offices", description="Example Requests:\n\noffices\n\n\noffices?fields=id,name,openingDate")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=OfficesApiResourceSwagger.GetOfficesResponse.class)))})})
    public String retrieveOffices(@Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="includeAllOffices") @Parameter(description="includeAllOffices") boolean onlyManualEntries, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().orphansOnly(Boolean.valueOf(false)).isSelfUser(Boolean.valueOf(false)).orderBy(orderBy).sortOrder(sortOrder).build();
        Collection offices = this.readPlatformService.retrieveAllOffices(onlyManualEntries, searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, offices, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Office Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\noffices/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=OfficesApiResourceSwagger.GetOfficesTemplateResponse.class))})})
    public String retrieveOfficeTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        OfficeData office = this.readPlatformService.retrieveNewOfficeTemplate();
        Collection allowedParents = this.readPlatformService.retrieveAllOfficesForDropdown();
        office = OfficeData.appendedTemplate((OfficeData)office, (Collection)allowedParents);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)office, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an Office", description="Mandatory Fields\nname, openingDate, parentId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=OfficesApiResourceSwagger.PostOfficesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=OfficesApiResourceSwagger.PostOfficesResponse.class))})})
    public String createOffice(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createOffice().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{officeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve an Office", description="Example Requests:\n\noffices/1\n\n\noffices/1?template=true\n\n\noffices/1?fields=id,name,parentName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=OfficesApiResourceSwagger.GetOfficesResponse.class))})})
    public String retrieveOffice(@PathParam(value="officeId") @Parameter(description="officeId") Long officeId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        OfficeData office = this.readPlatformService.retrieveOffice(officeId);
        if (settings.isTemplate()) {
            Collection allowedParents = this.readPlatformService.retrieveAllowedParents(officeId);
            office = OfficeData.appendedTemplate((OfficeData)office, (Collection)allowedParents);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)office, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve an Office using external id", description="Example Requests:\n\noffices/external-id/asd123\n\n\noffices/external-id/asd123?template=true\n\n\noffices/external-id/asd123?fields=id,name,parentName")
    public OfficesApiResourceSwagger.GetOfficesResponse retrieveOfficeByExternalId(@PathParam(value="externalId") @Parameter(description="externalId") String externalId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        OfficeData office = this.readPlatformService.retrieveOfficeWithExternalId(ExternalIdFactory.produce((String)externalId));
        if (settings.isTemplate()) {
            Collection allowedParents = this.readPlatformService.retrieveAllowedParents(office.getId());
            office = OfficeData.appendedTemplate((OfficeData)office, (Collection)allowedParents);
        }
        return this.officeSwaggerMapper.toGetOfficesResponse(office);
    }

    @PUT
    @Path(value="{officeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Office", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=OfficesApiResourceSwagger.PutOfficesOfficeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=OfficesApiResourceSwagger.PutOfficesOfficeIdResponse.class))})})
    public String updateOffice(@PathParam(value="officeId") @Parameter(description="officeId") Long officeId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateOffice(officeId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Office", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=OfficesApiResourceSwagger.PutOfficesOfficeIdRequest.class))})
    public OfficesApiResourceSwagger.PutOfficesOfficeIdResponse updateOfficeWithExternalId(@Parameter(description="externalId") @PathParam(value="externalId") String externalId, OfficesApiResourceSwagger.PutOfficesOfficeIdRequest apiRequestBody) {
        OfficeData office = this.readPlatformService.retrieveOfficeWithExternalId(ExternalIdFactory.produce((String)externalId));
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateOffice(office.getId()).withJson(this.gson.toJson((Object)apiRequestBody)).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.officeSwaggerMapper.toPutOfficesOfficeIdResponse(result);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getOfficeTemplate(@QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.OFFICES.toString(), null, null, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload office template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postOfficeTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.OFFICES.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @Generated
    public OfficesApiResource(OfficeSwaggerMapper officeSwaggerMapper, PlatformSecurityContext context, OfficeReadPlatformService readPlatformService, DefaultToApiJsonSerializer<OfficeData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, SqlValidator sqlValidator) {
        this.officeSwaggerMapper = officeSwaggerMapper;
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.sqlValidator = sqlValidator;
    }
}

