/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.exception;

import org.apache.fineract.infrastructure.core.exception.AbstractPlatformDomainRuleException;

public class DuplicateClientIdentifierException
extends AbstractPlatformDomainRuleException {
    private final Long documentTypeId;
    private final String identifierKey;
    private final String identifierType;

    public DuplicateClientIdentifierException(String identifierType) {
        super("error.msg.clientIdentifier.type.duplicate", "Active Client identifier of type " + identifierType + " is already present for this client", new Object[]{identifierType});
        this.identifierType = identifierType;
        this.identifierKey = null;
        this.documentTypeId = null;
    }

    public DuplicateClientIdentifierException(Long documentTypeId, String identifierType, String identifierKey) {
        super("error.msg.clientIdentifier.identityKey.duplicate", "Client identifier of type " + identifierType + " with value of " + identifierKey + " already exists.", new Object[]{identifierType, identifierKey});
        this.documentTypeId = documentTypeId;
        this.identifierType = identifierType;
        this.identifierKey = identifierKey;
    }

    public DuplicateClientIdentifierException(String clientName, String officeName, String identifierType, String identifierKey) {
        super("error.msg.clientIdentifier.identityKey.duplicate", "Client " + clientName + "under " + officeName + " Branch already has a " + identifierType + " with unique key " + identifierKey, new Object[]{clientName, officeName, identifierType, identifierKey});
        this.identifierType = identifierType;
        this.identifierKey = identifierKey;
        this.documentTypeId = null;
    }

    public Long getDocumentTypeId() {
        return this.documentTypeId;
    }

    public String getIdentifierKey() {
        return this.identifierKey;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }
}

