/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.applyholidaystoloans;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRescheduledDueHolidayBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.holiday.domain.Holiday;
import org.apache.fineract.organisation.holiday.domain.HolidayRepositoryWrapper;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.DefaultScheduledDateGenerator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanApplicationTerms;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanTermVariationsMapper;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.stereotype.Component;

@Component
public class ApplyHolidaysToLoansTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplyHolidaysToLoansTasklet.class);
    private final ConfigurationDomainService configurationDomainService;
    private final HolidayRepositoryWrapper holidayRepository;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanUtilService loanUtilService;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanTermVariationsMapper loanTermVariationsMapper;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        if (!isHolidayEnabled) {
            return RepeatStatus.FINISHED;
        }
        ArrayList<LoanStatus> loanStatuses = new ArrayList<LoanStatus>(Arrays.asList(LoanStatus.SUBMITTED_AND_PENDING_APPROVAL, LoanStatus.APPROVED, LoanStatus.ACTIVE));
        List holidays = this.holidayRepository.findUnprocessed();
        for (Holiday holiday : holidays) {
            Set offices = holiday.getOffices();
            ArrayList<Long> officeIds = new ArrayList<Long>(offices.size());
            for (Office office : offices) {
                officeIds.add((Long)office.getId());
            }
            ArrayList loans = new ArrayList();
            loans.addAll(this.loanRepositoryWrapper.findByClientOfficeIdsAndLoanStatus(officeIds, loanStatuses));
            loans.addAll(this.loanRepositoryWrapper.findByGroupOfficeIdsAndLoanStatus(officeIds, loanStatuses));
            for (Loan loan : loans) {
                this.applyHolidayToRepaymentScheduleDates(loan, holiday);
            }
            this.loanRepositoryWrapper.save(loans);
            holiday.setProcessed(true);
        }
        this.holidayRepository.save((Iterable)holidays);
        return RepeatStatus.FINISHED;
    }

    public void applyHolidayToRepaymentScheduleDates(Loan loan, Holiday holiday) {
        LocalDate adjustedRescheduleToDate = null;
        boolean isResheduleToNextRepaymentDate = holiday.getReScheduleType().isResheduleToNextRepaymentDate();
        adjustedRescheduleToDate = holiday.getReScheduleType().isResheduleToNextRepaymentDate() ? this.getNextRepaymentDate(loan, holiday) : holiday.getRepaymentsRescheduledTo();
        if (this.isRepaymentScheduleAdjustmentNeeded(adjustedRescheduleToDate)) {
            if (isResheduleToNextRepaymentDate) {
                this.adjustAllRepaymentSchedules(loan, holiday, adjustedRescheduleToDate);
            } else {
                this.adjustRepaymentSchedules(loan, holiday, adjustedRescheduleToDate);
            }
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRescheduledDueHolidayBusinessEvent(loan));
        }
    }

    private boolean isRepaymentScheduleAdjustmentNeeded(LocalDate adjustedRescheduleToDate) {
        return adjustedRescheduleToDate != null;
    }

    private void adjustRepaymentSchedules(Loan loan, Holiday holiday, LocalDate adjustedRescheduleToDate) {
        DefaultScheduledDateGenerator scheduledDateGenerator = new DefaultScheduledDateGenerator();
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, holiday.getFromDate());
        LoanApplicationTerms loanApplicationTerms = this.loanTermVariationsMapper.constructLoanApplicationTerms(scheduleGeneratorDTO, loan);
        LocalDate tmpFromDate = loan.getDisbursementDate();
        List installments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : installments) {
            LocalDate oldDueDate = loanRepaymentScheduleInstallment.getDueDate();
            if (!DateUtils.isEqual((LocalDate)tmpFromDate, (LocalDate)loanRepaymentScheduleInstallment.getFromDate())) {
                loanRepaymentScheduleInstallment.updateFromDate(tmpFromDate);
            }
            if (DateUtils.isDateWithinRange((LocalDate)oldDueDate, (LocalDate)holiday.getFromDate(), (LocalDate)holiday.getToDate())) {
                adjustedRescheduleToDate = scheduledDateGenerator.generateNextRepaymentDateWhenHolidayApply(adjustedRescheduleToDate, loanApplicationTerms);
                loanRepaymentScheduleInstallment.updateDueDate(adjustedRescheduleToDate);
            }
            tmpFromDate = loanRepaymentScheduleInstallment.getDueDate();
        }
    }

    private void adjustAllRepaymentSchedules(Loan loan, Holiday holiday, LocalDate adjustedRescheduleToDate) {
        DefaultScheduledDateGenerator scheduledDateGenerator = new DefaultScheduledDateGenerator();
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, holiday.getFromDate());
        LoanApplicationTerms loanApplicationTerms = this.loanTermVariationsMapper.constructLoanApplicationTerms(scheduleGeneratorDTO, loan);
        LocalDate tmpFromDate = loan.getDisbursementDate();
        List installments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : installments) {
            LocalDate oldDueDate = loanRepaymentScheduleInstallment.getDueDate();
            if (!DateUtils.isEqual((LocalDate)tmpFromDate, (LocalDate)loanRepaymentScheduleInstallment.getFromDate())) {
                loanRepaymentScheduleInstallment.updateFromDate(tmpFromDate);
            }
            if (!DateUtils.isBefore((LocalDate)oldDueDate, (LocalDate)holiday.getFromDate())) {
                adjustedRescheduleToDate = scheduledDateGenerator.generateNextRepaymentDate(adjustedRescheduleToDate, loanApplicationTerms, false);
                loanRepaymentScheduleInstallment.updateDueDate(adjustedRescheduleToDate);
            }
            tmpFromDate = loanRepaymentScheduleInstallment.getDueDate();
        }
    }

    private LocalDate getNextRepaymentDate(Loan loan, Holiday holiday) {
        LocalDate adjustedRescheduleToDate = null;
        LocalDate rescheduleToDate = holiday.getToDate();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : loan.getRepaymentScheduleInstallments()) {
            if (DateUtils.isEqual((LocalDate)rescheduleToDate, (LocalDate)loanRepaymentScheduleInstallment.getDueDate())) {
                adjustedRescheduleToDate = rescheduleToDate;
                break;
            }
            adjustedRescheduleToDate = this.doStandardMonthlyCheck(adjustedRescheduleToDate, rescheduleToDate, loanRepaymentScheduleInstallment);
        }
        return adjustedRescheduleToDate;
    }

    private LocalDate doStandardMonthlyCheck(LocalDate adjustedRescheduleToDate, LocalDate rescheduleToDate, LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment) {
        LocalDate dueDate = loanRepaymentScheduleInstallment.getDueDate();
        if (DateUtils.isAfter((LocalDate)rescheduleToDate, (LocalDate)dueDate) && DateUtils.isBefore((LocalDate)rescheduleToDate, (LocalDate)dueDate.plusDays(30L))) {
            adjustedRescheduleToDate = dueDate;
        }
        return adjustedRescheduleToDate;
    }

    @Generated
    public ApplyHolidaysToLoansTasklet(ConfigurationDomainService configurationDomainService, HolidayRepositoryWrapper holidayRepository, LoanRepositoryWrapper loanRepositoryWrapper, LoanUtilService loanUtilService, BusinessEventNotifierService businessEventNotifierService, LoanTermVariationsMapper loanTermVariationsMapper) {
        this.configurationDomainService = configurationDomainService;
        this.holidayRepository = holidayRepository;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanUtilService = loanUtilService;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanTermVariationsMapper = loanTermVariationsMapper;
    }
}

