/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import jakarta.persistence.PersistenceException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartAssembler;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.DepositProductDataValidator;
import org.apache.fineract.portfolio.savings.domain.DepositProductAssembler;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositProduct;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositProductRepository;
import org.apache.fineract.portfolio.savings.exception.RecurringDepositProductNotFoundException;
import org.apache.fineract.portfolio.savings.service.RecurringDepositProductWritePlatformService;
import org.apache.fineract.portfolio.tax.domain.TaxGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class RecurringDepositProductWritePlatformServiceJpaRepositoryImpl
implements RecurringDepositProductWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecurringDepositProductWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final RecurringDepositProductRepository recurringDepositProductRepository;
    private final DepositProductDataValidator fromApiJsonDataValidator;
    private final DepositProductAssembler depositProductAssembler;
    private final ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService;
    private final InterestRateChartAssembler chartAssembler;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        try {
            this.fromApiJsonDataValidator.validateForRecurringDepositCreate(command.json());
            RecurringDepositProduct product = this.depositProductAssembler.assembleRecurringDepositProduct(command);
            this.recurringDepositProductRepository.saveAndFlush((Object)product);
            this.accountMappingWritePlatformService.createSavingProductToGLAccountMapping((Long)product.getId(), command, DepositAccountType.RECURRING_DEPOSIT);
            return new CommandProcessingResultBuilder().withEntityId((Long)product.getId()).build();
        }
        catch (DataAccessException e) {
            this.handleDataIntegrityIssues(command, e.getMostSpecificCause(), (Exception)((Object)e));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            this.handleDataIntegrityIssues(command, ExceptionUtils.getRootCause((Throwable)dve.getCause()), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult update(Long productId, JsonCommand command) {
        try {
            Set savingsProductCharges;
            boolean updated;
            this.context.authenticatedUser();
            this.fromApiJsonDataValidator.validateForRecurringDepositUpdate(command.json());
            RecurringDepositProduct product = (RecurringDepositProduct)this.recurringDepositProductRepository.findById((Object)productId).orElseThrow(() -> new RecurringDepositProductNotFoundException(productId));
            product.setHelpers(this.chartAssembler);
            Map changes = product.update(command);
            if (changes.containsKey("charges") && !(updated = product.update(savingsProductCharges = this.depositProductAssembler.assembleListOfSavingsProductCharges(command, product.currency().getCode())))) {
                changes.remove("charges");
            }
            if (changes.containsKey("taxGroupId")) {
                TaxGroup taxGroup = this.depositProductAssembler.assembleTaxGroup(command);
                product.setTaxGroup(taxGroup);
                if (product.withHoldTax() && product.getTaxGroup() == null) {
                    ArrayList dataValidationErrors = new ArrayList();
                    DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositproduct");
                    Object taxGroupId = null;
                    baseDataValidator.reset().parameter("taxGroupId").value(taxGroupId).notBlank();
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
            boolean accountingTypeChanged = changes.containsKey("accountingRule");
            Map accountingMappingChanges = this.accountMappingWritePlatformService.updateSavingsProductToGLAccountMapping((Long)product.getId(), command, accountingTypeChanged, product.getAccountingType().intValue(), DepositAccountType.RECURRING_DEPOSIT);
            changes.putAll(accountingMappingChanges);
            if (!changes.isEmpty()) {
                this.recurringDepositProductRepository.saveAndFlush((Object)product);
            }
            return new CommandProcessingResultBuilder().withEntityId((Long)product.getId()).with(changes).build();
        }
        catch (DataAccessException e) {
            this.handleDataIntegrityIssues(command, e.getMostSpecificCause(), (Exception)((Object)e));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            this.handleDataIntegrityIssues(command, ExceptionUtils.getRootCause((Throwable)dve.getCause()), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult delete(Long productId) {
        this.context.authenticatedUser();
        RecurringDepositProduct product = (RecurringDepositProduct)this.recurringDepositProductRepository.findById((Object)productId).orElseThrow(() -> new RecurringDepositProductNotFoundException(productId));
        this.recurringDepositProductRepository.delete((Object)product);
        return new CommandProcessingResultBuilder().withEntityId((Long)product.getId()).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dae) {
        Object[] msgArgs;
        Throwable checkEx;
        Object msgCode = "error.msg.savingsproduct";
        Object msg = "Unknown data integrity issue with recurring deposit product.";
        String param = null;
        Throwable throwable = checkEx = realCause == null ? dae : realCause;
        if (checkEx.getMessage().contains("sp_unq_name")) {
            String name = command.stringValueOfParameterNamed("name");
            msgCode = (String)msgCode + ".duplicate.name";
            msg = "Recurring Deposit product with name `" + name + "` already exists";
            param = "name";
            msgArgs = new Object[]{name, dae};
        } else if (checkEx.getMessage().contains("sp_unq_short_name")) {
            String shortName = command.stringValueOfParameterNamed("shortName");
            msgCode = (String)msgCode + ".duplicate.short.name";
            msg = "Recurring Deposit product with short name `" + shortName + "` already exists";
            param = "shortName";
            msgArgs = new Object[]{shortName, dae};
        } else {
            msgCode = (String)msgCode + ".unknown.data.integrity.issue";
            msgArgs = new Object[]{dae};
        }
        log.error("Error occured.", (Throwable)dae);
        throw ErrorHandler.getMappable((Throwable)dae, (String)msgCode, (String)msg, (String)param, (Object[])msgArgs);
    }

    @Generated
    public RecurringDepositProductWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, RecurringDepositProductRepository recurringDepositProductRepository, DepositProductDataValidator fromApiJsonDataValidator, DepositProductAssembler depositProductAssembler, ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService, InterestRateChartAssembler chartAssembler) {
        this.context = context;
        this.recurringDepositProductRepository = recurringDepositProductRepository;
        this.fromApiJsonDataValidator = fromApiJsonDataValidator;
        this.depositProductAssembler = depositProductAssembler;
        this.accountMappingWritePlatformService = accountMappingWritePlatformService;
        this.chartAssembler = chartAssembler;
    }
}

