/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.self.pockets.service.AccountEntityService;
import org.apache.fineract.portfolio.self.savings.service.AppuserSavingsMapperReadService;

public class AccountEntityServiceForSavingsImpl
implements AccountEntityService {
    private static final String KEY = EntityAccountType.SAVINGS.name();
    private final PlatformSecurityContext context;
    private final AppuserSavingsMapperReadService appuserSavingsMapperReadService;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;

    public String getKey() {
        return KEY;
    }

    public void validateSelfUserAccountMapping(Long accountId) {
        if (!this.appuserSavingsMapperReadService.isSavingsMappedToUser(accountId, (Long)this.context.authenticatedUser().getId()).booleanValue()) {
            throw new SavingsAccountNotFoundException(accountId);
        }
    }

    public String retrieveAccountNumberByAccountId(Long accountId) {
        return this.savingsAccountReadPlatformService.retrieveAccountNumberByAccountId(accountId);
    }

    @Generated
    public AccountEntityServiceForSavingsImpl(PlatformSecurityContext context, AppuserSavingsMapperReadService appuserSavingsMapperReadService, SavingsAccountReadPlatformService savingsAccountReadPlatformService) {
        this.context = context;
        this.appuserSavingsMapperReadService = appuserSavingsMapperReadService;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
    }
}

