package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.GetLoanRescheduleRequestResponse;
import org.apache.fineract.client.models.GetRescheduleReasonsTemplateResponse;
import org.apache.fineract.client.models.PostCreateRescheduleLoansRequest;
import org.apache.fineract.client.models.PostCreateRescheduleLoansResponse;
import org.apache.fineract.client.models.PostUpdateRescheduleLoansRequest;
import org.apache.fineract.client.models.PostUpdateRescheduleLoansResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface RescheduleLoansApi {
    /**
    * Create loan reschedule request
    * Create a loan reschedule request.
        * @param postCreateRescheduleLoansRequest  (required)
    * @return Call&lt;PostCreateRescheduleLoansResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/rescheduleloans")
    Call<PostCreateRescheduleLoansResponse> createLoanRescheduleRequest(@retrofit2.http.Body PostCreateRescheduleLoansRequest postCreateRescheduleLoansRequest);

    /**
    * Retrieve loan reschedule request by schedule id
    * Retrieve loan reschedule request by schedule id
        * @param scheduleId  (required)
        * @param command  (optional)
    * @return Call&lt;GetLoanRescheduleRequestResponse&gt;
    */
    @GET("v1/rescheduleloans/{scheduleId}")
    Call<GetLoanRescheduleRequestResponse> readLoanRescheduleRequest(@retrofit2.http.Path("scheduleId") Long scheduleId, @retrofit2.http.Query("command") String command);

    /**
    * Retrieve all reschedule requests
    * Retrieve all reschedule requests.
        * @param command  (optional)
        * @param loanId  (optional)
    * @return Call&lt;List&lt;GetLoanRescheduleRequestResponse&gt;&gt;
    */
    @GET("v1/rescheduleloans")
    Call<List<GetLoanRescheduleRequestResponse>> retrieveAllRescheduleRequest(@retrofit2.http.Query("command") String command, @retrofit2.http.Query("loanId") Long loanId);

    /**
    * Retrieve all reschedule loan reasons
    * Retrieve all reschedule loan reasons as a template
    * @return Call&lt;GetRescheduleReasonsTemplateResponse&gt;
    */
    @GET("v1/rescheduleloans/template")
    Call<GetRescheduleReasonsTemplateResponse> retrieveTemplate10();

    /**
    * Update loan reschedule request
    * Update a loan reschedule request by either approving/rejecting it.
        * @param scheduleId  (required)
        * @param postUpdateRescheduleLoansRequest  (required)
        * @param command  (optional)
    * @return Call&lt;PostUpdateRescheduleLoansResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/rescheduleloans/{scheduleId}")
    Call<PostUpdateRescheduleLoansResponse> updateLoanRescheduleRequest(@retrofit2.http.Path("scheduleId") Long scheduleId, @retrofit2.http.Body PostUpdateRescheduleLoansRequest postUpdateRescheduleLoansRequest, @retrofit2.http.Query("command") String command);



        /**
        * Create loan reschedule request
        * Create a loan reschedule request.
            * @param postCreateRescheduleLoansRequest  (required)
        * @return Call&lt;PostCreateRescheduleLoansResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/rescheduleloans")
    Call<PostCreateRescheduleLoansResponse> createLoanRescheduleRequest(@retrofit2.http.Body PostCreateRescheduleLoansRequest postCreateRescheduleLoansRequest, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve loan reschedule request by schedule id
        * Retrieve loan reschedule request by schedule id
            * @param scheduleId  (required)
            * @param command  (optional)
        * @return Call&lt;GetLoanRescheduleRequestResponse&gt;
        */
    @GET("v1/rescheduleloans/{scheduleId}")
    Call<GetLoanRescheduleRequestResponse> readLoanRescheduleRequest(@retrofit2.http.Path("scheduleId") Long scheduleId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve all reschedule requests
        * Retrieve all reschedule requests.
            * @param command  (optional)
            * @param loanId  (optional)
        * @return Call&lt;List&lt;GetLoanRescheduleRequestResponse&gt;&gt;
        */
    @GET("v1/rescheduleloans")
    Call<List<GetLoanRescheduleRequestResponse>> retrieveAllRescheduleRequest(@retrofit2.http.Query("command") String command, @retrofit2.http.Query("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve all reschedule loan reasons
        * Retrieve all reschedule loan reasons as a template
        * @return Call&lt;GetRescheduleReasonsTemplateResponse&gt;
        */
    @GET("v1/rescheduleloans/template")
    Call<GetRescheduleReasonsTemplateResponse> retrieveTemplate10(@HeaderMap Map<String, String> headers);

        /**
        * Update loan reschedule request
        * Update a loan reschedule request by either approving/rejecting it.
            * @param scheduleId  (required)
            * @param postUpdateRescheduleLoansRequest  (required)
            * @param command  (optional)
        * @return Call&lt;PostUpdateRescheduleLoansResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/rescheduleloans/{scheduleId}")
    Call<PostUpdateRescheduleLoansResponse> updateLoanRescheduleRequest(@retrofit2.http.Path("scheduleId") Long scheduleId, @retrofit2.http.Body PostUpdateRescheduleLoansRequest postUpdateRescheduleLoansRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);


}
