/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.accountnumberformat.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatEnumerations;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AccountNumberFormatEnumerations {
    public static final Set<AccountNumberPrefixType> accountNumberPrefixesForClientAccounts = Collections.unmodifiableSet(new HashSet<AccountNumberPrefixType>(Arrays.asList(AccountNumberPrefixType.OFFICE_NAME, AccountNumberPrefixType.CLIENT_TYPE, AccountNumberPrefixType.PREFIX_SHORT_NAME)));
    public static final Set<AccountNumberPrefixType> accountNumberPrefixesForLoanAccounts = Collections.unmodifiableSet(new HashSet<AccountNumberPrefixType>(Arrays.asList(AccountNumberPrefixType.OFFICE_NAME, AccountNumberPrefixType.LOAN_PRODUCT_SHORT_NAME, AccountNumberPrefixType.PREFIX_SHORT_NAME)));
    public static final Set<AccountNumberPrefixType> accountNumberPrefixesForSavingsAccounts = Collections.unmodifiableSet(new HashSet<AccountNumberPrefixType>(Arrays.asList(AccountNumberPrefixType.OFFICE_NAME, AccountNumberPrefixType.SAVINGS_PRODUCT_SHORT_NAME, AccountNumberPrefixType.PREFIX_SHORT_NAME)));
    public static final Set<AccountNumberPrefixType> accountNumberPrefixesForCenters = Collections.unmodifiableSet(new HashSet<AccountNumberPrefixType>(Collections.singletonList(AccountNumberPrefixType.OFFICE_NAME)));
    public static final Set<AccountNumberPrefixType> accountNumberPrefixesForGroups = Collections.unmodifiableSet(new HashSet<AccountNumberPrefixType>(Collections.singletonList(AccountNumberPrefixType.OFFICE_NAME)));

    private AccountNumberFormatEnumerations() {
    }

    public static EnumOptionData entityAccountType(Integer accountTypeId) {
        return AccountNumberFormatEnumerations.entityAccountType((EntityAccountType)EntityAccountType.fromInt((int)accountTypeId));
    }

    public static List<EnumOptionData> entityAccountType(EntityAccountType[] entityAccountTypes) {
        ArrayList<EnumOptionData> optionDatas = new ArrayList<EnumOptionData>();
        for (EntityAccountType accountType : entityAccountTypes) {
            optionDatas.add(AccountNumberFormatEnumerations.entityAccountType((EntityAccountType)accountType));
        }
        return optionDatas;
    }

    public static EnumOptionData entityAccountType(EntityAccountType accountType) {
        EnumOptionData optionData = new EnumOptionData(Long.valueOf(accountType.getValue().longValue()), accountType.getCode(), accountType.toString());
        return optionData;
    }

    public static EnumOptionData accountNumberPrefixType(Integer accountNumberPrefixTypeId) {
        return AccountNumberFormatEnumerations.entityAccountType((AccountNumberPrefixType)AccountNumberPrefixType.fromInt((int)accountNumberPrefixTypeId));
    }

    public static List<EnumOptionData> accountNumberPrefixType(AccountNumberPrefixType[] accountNumberPrefixTypes) {
        ArrayList<EnumOptionData> optionDatas = new ArrayList<EnumOptionData>();
        for (AccountNumberPrefixType accountNumberPrefixType : accountNumberPrefixTypes) {
            optionDatas.add(AccountNumberFormatEnumerations.entityAccountType((AccountNumberPrefixType)accountNumberPrefixType));
        }
        return optionDatas;
    }

    public static EnumOptionData entityAccountType(AccountNumberPrefixType accountNumberPrefixType) {
        EnumOptionData optionData = new EnumOptionData(Long.valueOf(accountNumberPrefixType.getValue().longValue()), accountNumberPrefixType.getCode(), accountNumberPrefixType.toString());
        return optionData;
    }

    public static List<EnumOptionData> accountNumberPrefixType(Object[] array) {
        AccountNumberPrefixType[] accountNumberPrefixTypes = (AccountNumberPrefixType[])Arrays.copyOf(array, array.length, AccountNumberPrefixType[].class);
        return AccountNumberFormatEnumerations.accountNumberPrefixType((AccountNumberPrefixType[])accountNumberPrefixTypes);
    }
}

