/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.security;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"diagnostics"})
public class SecurityFilterChainDiagnostics
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityFilterChainDiagnostics.class);
    private final List<SecurityFilterChain> filterChains;

    public void afterPropertiesSet() throws Exception {
        this.filterChains.forEach(arg_0 -> this.printFilterChain(arg_0));
    }

    private void printFilterChain(SecurityFilterChain filterChain) {
        if (filterChain instanceof DefaultSecurityFilterChain) {
            this.printDefaultFilterChain((DefaultSecurityFilterChain)filterChain);
        } else {
            this.printUnknownFilterChain(filterChain);
        }
    }

    private void printDefaultFilterChain(DefaultSecurityFilterChain filterChain) {
        log.info("\nFilter chain matcher: {}\nFilters in order:\n{}\n", (Object)filterChain.getRequestMatcher(), (Object)this.getFormattedFilters(filterChain));
    }

    private String getFormattedFilters(DefaultSecurityFilterChain filterChain) {
        StringBuilder result = new StringBuilder();
        filterChain.getFilters().forEach(f -> {
            result.append("- ");
            result.append(f.getClass().getName());
            result.append(System.lineSeparator());
        });
        return result.toString();
    }

    private void printUnknownFilterChain(SecurityFilterChain filterChain) {
        log.info("Filter chain:\n{}\n", (Object)filterChain);
    }

    @Generated
    public SecurityFilterChainDiagnostics(List<SecurityFilterChain> filterChains) {
        this.filterChains = filterChains;
    }
}

