/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.jobname;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.jobs.service.jobname.JobNameData;
import org.apache.fineract.infrastructure.jobs.service.jobname.JobNameProvider;
import org.springframework.stereotype.Component;

@Component
public class JobNameService {
    private final Collection<JobNameProvider> providers;

    public JobNameData getJobByHumanReadableName(String jobName) {
        Optional<JobNameData> optionalJob = this.getJobNames().stream().filter(jn -> jobName.equals(jn.getHumanReadableName())).findAny();
        return optionalJob.orElseThrow(() -> new IllegalArgumentException("Job not found by name: " + jobName));
    }

    private Set<JobNameData> getJobNames() {
        return this.providers.stream().map(JobNameProvider::provide).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Generated
    public JobNameService(Collection<JobNameProvider> providers) {
        this.providers = providers;
    }
}

