/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.service;

import jakarta.persistence.PersistenceException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCategory;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCategoryRepository;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCategoryCannotBeDeletedException;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCategoryNotFoundException;
import org.apache.fineract.organisation.provisioning.serialization.ProvisioningCategoryDefinitionJsonDeserializer;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCategoryWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaSystemException;

public class ProvisioningCategoryWritePlatformServiceJpaRepositoryImpl
implements ProvisioningCategoryWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProvisioningCategoryWritePlatformServiceJpaRepositoryImpl.class);
    private final ProvisioningCategoryRepository provisioningCategoryRepository;
    private final ProvisioningCategoryDefinitionJsonDeserializer fromApiJsonDeserializer;
    private final JdbcTemplate jdbcTemplate;

    public CommandProcessingResult createProvisioningCateogry(JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            ProvisioningCategory provisioningCategory = ProvisioningCategory.fromJson((JsonCommand)command);
            this.provisioningCategoryRepository.saveAndFlush((Object)provisioningCategory);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)provisioningCategory.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult deleteProvisioningCateogry(JsonCommand command) {
        this.fromApiJsonDeserializer.validateForCreate(command.json());
        ProvisioningCategory provisioningCategory = ProvisioningCategory.fromJson((JsonCommand)command);
        boolean isProvisioningCategoryInUse = this.isAnyLoanProductsAssociateWithThisProvisioningCategory((Long)provisioningCategory.getId());
        if (isProvisioningCategoryInUse) {
            throw new ProvisioningCategoryCannotBeDeletedException("error.msg.provisioningcategory.cannot.be.deleted.it.is.already.used.in.loanproduct", "This provisioning category cannot be deleted, it is already used in loan product", new Object[0]);
        }
        this.provisioningCategoryRepository.delete((Object)provisioningCategory);
        return new CommandProcessingResultBuilder().withEntityId((Long)provisioningCategory.getId()).build();
    }

    public CommandProcessingResult updateProvisioningCategory(Long categoryId, JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            ProvisioningCategory provisioningCategoryForUpdate = (ProvisioningCategory)this.provisioningCategoryRepository.findById((Object)categoryId).orElseThrow(() -> new ProvisioningCategoryNotFoundException(categoryId));
            Map changes = provisioningCategoryForUpdate.update(command);
            if (!changes.isEmpty()) {
                this.provisioningCategoryRepository.saveAndFlush((Object)provisioningCategoryForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(categoryId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private boolean isAnyLoanProductsAssociateWithThisProvisioningCategory(Long categoryID) {
        String sql = "select (CASE WHEN (exists (select 1 from m_loanproduct_provisioning_details lpd where lpd.category_id = ?)) = 1 THEN 'true' ELSE 'false' END)";
        String isLoansUsingCharge = (String)this.jdbcTemplate.queryForObject("select (CASE WHEN (exists (select 1 from m_loanproduct_provisioning_details lpd where lpd.category_id = ?)) = 1 THEN 'true' ELSE 'false' END)", String.class, new Object[]{categoryID});
        return Boolean.valueOf(isLoansUsingCharge);
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("category_name")) {
            String name = command.stringValueOfParameterNamed("category_name");
            throw new PlatformDataIntegrityException("error.msg.provisioning.duplicate.categoryname", "Provisioning Cateory with name `" + name + "` already exists", "category name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.charge.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public ProvisioningCategoryWritePlatformServiceJpaRepositoryImpl(ProvisioningCategoryRepository provisioningCategoryRepository, ProvisioningCategoryDefinitionJsonDeserializer fromApiJsonDeserializer, JdbcTemplate jdbcTemplate) {
        this.provisioningCategoryRepository = provisioningCategoryRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.jdbcTemplate = jdbcTemplate;
    }
}

