/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.data.ClientFamilyMemberRequest;
import org.apache.fineract.portfolio.client.data.ClientFamilyMembersData;
import org.apache.fineract.portfolio.client.service.ClientFamilyMembersReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/clients/{clientId}/familymembers")
@Component
@Tag(name="Client Family Member", description="")
public class ClientFamilyMembersApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "FamilyMembers";
    private final PlatformSecurityContext context;
    private final ClientFamilyMembersReadPlatformService readPlatformService;
    private final ToApiJsonSerializer<ClientFamilyMembersData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="/{familyMemberId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ClientFamilyMembersData getFamilyMember(@PathParam(value="familyMemberId") Long familyMemberId, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.getClientFamilyMember(familyMemberId.longValue());
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ClientFamilyMembersData> getFamilyMembers(@PathParam(value="clientId") long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.getClientFamilyMembers(clientId);
    }

    @GET
    @Path(value="/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ClientFamilyMembersData getTemplate(@PathParam(value="clientId") long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveTemplate();
    }

    @PUT
    @Path(value="/{familyMemberId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult updateClientFamilyMembers(@PathParam(value="familyMemberId") long familyMemberId, ClientFamilyMemberRequest clientFamilyMemberRequest, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateFamilyMembers(familyMemberId).withJson(this.toApiJsonSerializer.serialize((Object)clientFamilyMemberRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult addClientFamilyMembers(@PathParam(value="clientId") long clientid, ClientFamilyMemberRequest clientFamilyMemberRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().addFamilyMembers(clientid).withJson(this.toApiJsonSerializer.serialize((Object)clientFamilyMemberRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @DELETE
    @Path(value="/{familyMemberId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult deleteClientFamilyMembers(@PathParam(value="familyMemberId") long familyMemberId, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteFamilyMembers(familyMemberId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public ClientFamilyMembersApiResource(PlatformSecurityContext context, ClientFamilyMembersReadPlatformService readPlatformService, ToApiJsonSerializer<ClientFamilyMembersData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

