/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.loanaccount.data.LoanPointInTimeData;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.arrears.LoanArrearsData;
import org.apache.fineract.portfolio.loanaccount.service.LoanArrearsAgingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanPointInTimeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Service
@Transactional
public class LoanPointInTimeServiceImpl
implements LoanPointInTimeService {
    private final LoanUtilService loanUtilService;
    private final LoanScheduleService loanScheduleService;
    private final LoanAssembler loanAssembler;
    private final LoanPointInTimeData.Mapper dataMapper;
    private final EntityManager entityManager;
    private final LoanArrearsAgingService arrearsAgingService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoanPointInTimeData retrieveAt(Long loanId, LocalDate date) {
        this.entityManager.setFlushMode(FlushModeType.COMMIT);
        this.validateSingularRetrieval(loanId, date);
        HashMap originalBDs = ThreadLocalContextUtil.getBusinessDates();
        try {
            ThreadLocalContextUtil.setBusinessDates(new HashMap<BusinessDateType, LocalDate>(Map.of(BusinessDateType.BUSINESS_DATE, date)));
            Loan loan = this.loanAssembler.assembleFrom(loanId);
            int txCount = loan.getLoanTransactions().size();
            int chargeCount = loan.getCharges().size();
            this.removeAfterDateTransactions(loan, date);
            this.removeAfterDateCharges(loan, date);
            int afterRemovalTxCount = loan.getLoanTransactions().size();
            int afterRemovalChargeCount = loan.getCharges().size();
            if (txCount != afterRemovalTxCount || chargeCount != afterRemovalChargeCount) {
                ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null, null);
                this.loanScheduleService.regenerateScheduleWithReprocessingTransactions(loan, scheduleGeneratorDTO);
            }
            LoanArrearsData arrearsData = this.arrearsAgingService.calculateArrearsForLoan(loan);
            LoanPointInTimeData result = this.dataMapper.map(loan);
            result.setArrears(arrearsData);
            LoanPointInTimeData loanPointInTimeData = result;
            return loanPointInTimeData;
        }
        finally {
            this.entityManager.clear();
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            ThreadLocalContextUtil.setBusinessDates((HashMap)originalBDs);
        }
    }

    private void removeAfterDateCharges(Loan loan, LocalDate date) {
        loan.removeCharges(c -> DateUtils.isAfter((LocalDate)c.getEffectiveDueDate(), (LocalDate)date));
    }

    private void removeAfterDateTransactions(Loan loan, LocalDate date) {
        loan.removeLoanTransactions(tx -> DateUtils.isAfter((LocalDate)tx.getTransactionDate(), (LocalDate)date));
    }

    private void validateSingularRetrieval(Long loanId, LocalDate date) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan");
        baseDataValidator.reset().parameter("loanId").value((Object)loanId).notNull();
        baseDataValidator.reset().parameter("date").value((Object)date).notNull().notBlank();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public List<LoanPointInTimeData> retrieveAt(List<Long> loanIds, LocalDate date) {
        this.validateBulkRetrieval(loanIds, date);
        List<LoanPointInTimeData> result = loanIds.stream().map(loanId -> this.retrieveAt(loanId, date)).toList();
        TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
        return result;
    }

    private void validateBulkRetrieval(List<Long> loanIds, LocalDate date) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan");
        baseDataValidator.reset().parameter("loanIds").value(loanIds).notNull().listNotEmpty();
        baseDataValidator.reset().parameter("date").value((Object)date).notNull().notBlank();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    @Generated
    public LoanPointInTimeServiceImpl(LoanUtilService loanUtilService, LoanScheduleService loanScheduleService, LoanAssembler loanAssembler, LoanPointInTimeData.Mapper dataMapper, EntityManager entityManager, LoanArrearsAgingService arrearsAgingService) {
        this.loanUtilService = loanUtilService;
        this.loanScheduleService = loanScheduleService;
        this.loanAssembler = loanAssembler;
        this.dataMapper = dataMapper;
        this.entityManager = entityManager;
        this.arrearsAgingService = arrearsAgingService;
    }
}

