/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.accounting.common.AccountingEnumerations;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingReadPlatformService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartData;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.DepositsApiConstants;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.api.FixedDepositProductsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.data.FixedDepositProductData;
import org.apache.fineract.portfolio.savings.service.DepositProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/fixeddepositproducts")
@Component
@Tag(name="Fixed Deposit Product", description="This is one of the advanced term deposit product offered by MFI's. The Fixed Deposit Products (aka FD) product offerings are modeled using this API.\n\nThe FD products are deposit accounts which are held for a fixed term \u2013 like 1 year, 2 years etc.\n\nWhen creating fixed deposit accounts, the details from the fixed deposit product are used to auto fill details of the fixed deposit account application process.")
public class FixedDepositProductsApiResource {
    private final DepositProductReadPlatformService depositProductReadPlatformService;
    private final SavingsDropdownReadPlatformService savingsDropdownReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<FixedDepositProductData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final AccountingDropdownReadPlatformService accountingDropdownReadPlatformService;
    private final ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final InterestRateChartReadPlatformService chartReadPlatformService;
    private final InterestRateChartReadPlatformService interestRateChartReadPlatformService;
    private final DepositsDropdownReadPlatformService depositsDropdownReadPlatformService;
    private final DropdownReadPlatformService dropdownReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final TaxReadPlatformService taxReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Fixed Deposit Product", description="Creates a Fixed Deposit Product\n\nMandatory Fields: name, shortName, description, currencyCode, digitsAfterDecimal,inMultiplesOf, interestCompoundingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minDepositTerm, minDepositTermTypeId, accountingRule\n\nOptional Fields: lockinPeriodFrequency, lockinPeriodFrequencyType, maxDepositTerm, maxDepositTermTypeId, inMultiplesOfDepositTerm, inMultiplesOfDepositTermTypeId, preClosurePenalApplicable, preClosurePenalInterest, preClosurePenalInterestOnTypeId, feeToIncomeAccountMappings, penaltyToIncomeAccountMappings, charges, charts, , withHoldTax, taxGroupId\n\n\nMandatory Fields for Cash based accounting (accountingRule = 2): savingsReferenceAccountId, savingsControlAccountId, interestOnSavingsAccountId, incomeFromFeeAccountId, transfersInSuspenseAccountId, incomeFromPenaltyAccountId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=FixedDepositProductsApiResourceSwagger.PostFixedDepositProductsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositProductsApiResourceSwagger.PostFixedDepositProductsResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createFixedDepositProduct().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Fixed Deposit Product", description="Updates a Fixed Deposit Product")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=FixedDepositProductsApiResourceSwagger.PutFixedDepositProductsProductIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositProductsApiResourceSwagger.PutFixedDepositProductsProductIdResponse.class))})})
    public String update(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateFixedDepositProduct(productId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Fixed Deposit Products", description="Lists Fixed Deposit Products\n\nExample Requests:\n\nfixeddepositproducts\n\n\nfixeddepositproducts?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FixedDepositProductsApiResourceSwagger.GetFixedDepositProductsResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("fixeddepositproduct");
        Collection products = this.depositProductReadPlatformService.retrieveAll(DepositAccountType.FIXED_DEPOSIT);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, products, DepositsApiConstants.FIXED_DEPOSIT_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Fixed Deposit Product", description="Retrieves a Fixed Deposit Product\n\nExample Requests:\n\nfixeddepositproducts/1\n\n\nfixeddepositproducts/1?template=true\n\n\nfixeddepositproducts/1?fields=name,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositProductsApiResourceSwagger.GetFixedDepositProductsProductIdResponse.class))})})
    public String retrieveOne(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("fixeddepositproduct");
        FixedDepositProductData fixedDepositProductData = (FixedDepositProductData)this.depositProductReadPlatformService.retrieveOne(DepositAccountType.FIXED_DEPOSIT, productId);
        List charges = this.chargeReadPlatformService.retrieveSavingsProductCharges(productId);
        fixedDepositProductData = FixedDepositProductData.withCharges((FixedDepositProductData)fixedDepositProductData, (Collection)charges);
        Collection charts = this.chartReadPlatformService.retrieveAllWithSlabsWithTemplate(productId);
        fixedDepositProductData = FixedDepositProductData.withInterestChart((FixedDepositProductData)fixedDepositProductData, (Collection)charts);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (fixedDepositProductData.hasAccountingEnabled()) {
            Map accountingMappings = this.accountMappingReadPlatformService.fetchAccountMappingDetailsForSavingsProduct(productId, Integer.valueOf(fixedDepositProductData.accountingRuleTypeId()));
            List paymentChannelToFundSourceMappings = this.accountMappingReadPlatformService.fetchPaymentTypeToFundSourceMappingsForSavingsProduct(productId);
            List feeToGLAccountMappings = this.accountMappingReadPlatformService.fetchFeeToIncomeAccountMappingsForSavingsProduct(productId);
            List penaltyToGLAccountMappings = this.accountMappingReadPlatformService.fetchPenaltyToIncomeAccountMappingsForSavingsProduct(productId);
            fixedDepositProductData = FixedDepositProductData.withAccountingDetails((FixedDepositProductData)fixedDepositProductData, (Map)accountingMappings, (Collection)paymentChannelToFundSourceMappings, (Collection)feeToGLAccountMappings, (Collection)penaltyToGLAccountMappings);
        }
        if (settings.isTemplate()) {
            fixedDepositProductData = this.handleTemplateRelatedData(fixedDepositProductData);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)fixedDepositProductData, DepositsApiConstants.FIXED_DEPOSIT_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("fixeddepositproduct");
        FixedDepositProductData fixedDepositProduct = this.handleTemplateRelatedData(null);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)fixedDepositProduct, DepositsApiConstants.FIXED_DEPOSIT_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    private FixedDepositProductData handleTemplateRelatedData(FixedDepositProductData savingsProduct) {
        EnumOptionData interestCompoundingPeriodType = SavingsEnumerations.compoundingInterestPeriodType((SavingsCompoundingInterestPeriodType)SavingsCompoundingInterestPeriodType.DAILY);
        EnumOptionData interestPostingPeriodType = SavingsEnumerations.interestPostingPeriodType((SavingsPostingInterestPeriodType)SavingsPostingInterestPeriodType.MONTHLY);
        EnumOptionData interestCalculationType = SavingsEnumerations.interestCalculationType((SavingsInterestCalculationType)SavingsInterestCalculationType.DAILY_BALANCE);
        EnumOptionData interestCalculationDaysInYearType = SavingsEnumerations.interestCalculationDaysInYearType((SavingsInterestCalculationDaysInYearType)SavingsInterestCalculationDaysInYearType.DAYS_365);
        EnumOptionData accountingRule = AccountingEnumerations.accountingRuleType((AccountingRuleType)AccountingRuleType.NONE);
        CurrencyData currency = CurrencyData.blank();
        List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        if (currencyOptions.size() == 1) {
            currency = (CurrencyData)new ArrayList(currencyOptions).get(0);
        }
        Collection interestCompoundingPeriodTypeOptions = this.savingsDropdownReadPlatformService.retrieveCompoundingInterestPeriodTypeOptions();
        Collection interestPostingPeriodTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestPostingPeriodTypeOptions();
        Collection interestCalculationTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestCalculationTypeOptions();
        Collection interestCalculationDaysInYearTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestCalculationDaysInYearTypeOptions();
        Collection lockinPeriodFrequencyTypeOptions = this.savingsDropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
        Collection withdrawalFeeTypeOptions = this.savingsDropdownReadPlatformService.retrievewithdrawalFeeTypeOptions();
        List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        List accountingRuleOptions = this.accountingDropdownReadPlatformService.retrieveAccountingRuleTypeOptions();
        Map accountingMappingOptions = this.accountingDropdownReadPlatformService.retrieveAccountMappingOptionsForSavingsProducts();
        Collection preClosurePenalInterestOnTypeOptions = this.depositsDropdownReadPlatformService.retrievePreClosurePenalInterestOnTypeOptions();
        List periodFrequencyTypeOptions = this.dropdownReadPlatformService.retrievePeriodFrequencyTypeOptions();
        boolean feeChargesOnly = true;
        List chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(true);
        chargeOptions = CollectionUtils.isEmpty((Collection)chargeOptions) ? null : chargeOptions;
        List penaltyOptions = this.chargeReadPlatformService.retrieveSavingsApplicablePenalties();
        penaltyOptions = CollectionUtils.isEmpty((Collection)penaltyOptions) ? null : penaltyOptions;
        List taxGroupOptions = this.taxReadPlatformService.retrieveTaxGroupsForLookUp();
        InterestRateChartData chartTemplate = this.interestRateChartReadPlatformService.template();
        FixedDepositProductData fixedDepositProductToReturn = null;
        fixedDepositProductToReturn = savingsProduct != null ? FixedDepositProductData.withTemplate((FixedDepositProductData)savingsProduct, (Collection)currencyOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, (Collection)paymentTypeOptions, (Collection)accountingRuleOptions, (Map)accountingMappingOptions, (Collection)chargeOptions, (Collection)penaltyOptions, (InterestRateChartData)chartTemplate, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions, (Collection)taxGroupOptions) : FixedDepositProductData.template((CurrencyData)currency, (EnumOptionData)interestCompoundingPeriodType, (EnumOptionData)interestPostingPeriodType, (EnumOptionData)interestCalculationType, (EnumOptionData)interestCalculationDaysInYearType, (EnumOptionData)accountingRule, (Collection)currencyOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, (Collection)paymentTypeOptions, (Collection)accountingRuleOptions, (Map)accountingMappingOptions, (Collection)chargeOptions, (Collection)penaltyOptions, (InterestRateChartData)chartTemplate, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions, (Collection)taxGroupOptions);
        return fixedDepositProductToReturn;
    }

    @DELETE
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Fixed Deposit Product", description="Deletes a Fixed Deposit Product")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositProductsApiResourceSwagger.DeleteFixedDepositProductsProductIdResponse.class))})})
    public String delete(@PathParam(value="productId") @Parameter(description="productId") Long productId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteFixedDepositProduct(productId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public FixedDepositProductsApiResource(DepositProductReadPlatformService depositProductReadPlatformService, SavingsDropdownReadPlatformService savingsDropdownReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<FixedDepositProductData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService, ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, InterestRateChartReadPlatformService chartReadPlatformService, InterestRateChartReadPlatformService interestRateChartReadPlatformService, DepositsDropdownReadPlatformService depositsDropdownReadPlatformService, DropdownReadPlatformService dropdownReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, TaxReadPlatformService taxReadPlatformService) {
        this.depositProductReadPlatformService = depositProductReadPlatformService;
        this.savingsDropdownReadPlatformService = savingsDropdownReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.accountingDropdownReadPlatformService = accountingDropdownReadPlatformService;
        this.accountMappingReadPlatformService = accountMappingReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.chartReadPlatformService = chartReadPlatformService;
        this.interestRateChartReadPlatformService = interestRateChartReadPlatformService;
        this.depositsDropdownReadPlatformService = depositsDropdownReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.taxReadPlatformService = taxReadPlatformService;
    }
}

