/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.products.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.portfolio.loanproduct.api.LoanProductsApiResource;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/loanproducts")
@Component
@Tag(name="Self Loan Products", description="A Loan product is a template that is used when creating a loan. Much of the template definition can be overridden during loan creation.\n\nField Descriptions\nname\nName associated with loan product on system.\nshortName\nShort name associated with a loan product. \nAn abbreviated version of the name, used in reports or menus where space is limited, such as Collection Sheets.\ndescription\nFor providing helpful description of product offering.\nfundId\nFor associating a loan product with a given fund by default.\nincludeInBorrowerCycle\nIt is a flag, Used to denote whether the loans should include in loan cycle counter or not.\nuseBorrowerCycle\nIt is a flag, Used to denote whether the loans should depend on \nborrower loan cycle counter or not.\ncurrencyCode\nA three letter ISO code of currency.\ndigitsAfterDecimal\nOverride the currency default value for digitsAfterDecimal.\ninMultiplesOf\nOverride the default value for rounding currency to multiples of value provided.\ninstallmentAmountInMultiplesOf\nOverride the default value for rounding instalment amount to multiples of value provided.\nprincipal\nThe loan amount to be disbursed to through loan.\nnumberOfRepayments\nNumber of installments to repay.\nUsed like: numberOfRepayments Every repaymentEvery repaymentFrequencyType\ne.g. 10 (repayments) Every 12 Weeks\nrepaymentEvery\nUsed like: numberOfRepayments Every repaymentEvery repaymentFrequencyType\ne.g. 10 (repayments) Every 12 Weeks\nrepaymentFrequencyType\nUsed like: numberOfRepayments Every repaymentEvery repaymentFrequencyType\ne.g. 10 (repayments) Every 12 Weeks \nExample Values: 0=Days, 1=Weeks, 2=Months\ninterestRatePerPeriod\nInterest Rate.\nUsed like: interestRatePerPeriod % interestRateFrequencyType - interestType\ne.g. 12.0000% Per year - Declining Balance\ninterestRateFrequencyType\nUsed like: interestRatePerPeriod% interestRateFrequencyType - interestType\ne.g. 12.0000% Per year - Declining Balance \nExample Values: 2=Per month, 3=Per year\namortizationType\nExample Values: 0=Equal principle payments, 1=Equal installments\ninterestType\nUsed like: interestRatePerPeriod% interestRateFrequencyType - interestType\ne.g. 12.0000% Per year - Declining Balance \nExample Values: 0=Declining Balance, 1=Flat\ninterestCalculationPeriodType\nExample Values: 0=Daily, 1=Same as repayment period\nallowPartialPeriodInterestCalcualtion\nThis value will be supported along with interestCalculationPeriodType as Same as repayment period to calculate interest for partial periods. Example: Interest charged from is 5th of April , Principal is 10000 and interest is 1% per month then the interest will be (10000 * 1%)* (25/30) , it calculates for the month first then calculates exact periods between start date and end date(can be a decimal)\ninArrearsTolerance\nThe amount that can be 'waived' at end of all loan payments because it is too small to worry about.\nThis is also the tolerance amount assessed when determining if a loan is in arrears.\nprincipalVariationsForBorrowerCycle,interestRateVariationsForBorrowerCycle,\nnumberOfRepaymentVariationsForBorrowerCycle\nVariations for loan, based on borrower cycle number\nminimumDaysBetweenDisbursalAndFirstRepayment\nThe minimum number of days allowed between a Loan disbursal and its first repayment.\nprincipalThresholdForLastInstalment\nField represents percentage of current instalment principal amount for comparing against principal outstanding to add another repayment instalment. If the outstanding principal amount is less then calculated amount, remaining outstanding amount will be added to current instalment. Default value for multi disburse loan is 50% and non-multi disburse loan is 0%\ncanDefineInstallmentAmount\nif provided as true, then fixed instalment amount can be provided from loan account.\ntransactionProcessingStrategyCode\nAn enumeration that indicates the type of transaction processing strategy to be used. This relates to functionality that is also known as Payment Application Logic.\nA number of out of the box approaches exist, some are custom to specific MFIs, some are more general and indicate the order in which payments are processed.\n\nRefer to the Payment Application Logic / Transaction Processing Strategy section in the appendix for more detailed overview of each available payment application logic provided out of the box.\n\nList of current approaches:\n1 = Mifos style (Similar to Old Mifos)\n2 = Heavensfamily (Custom MFI approach)\n3 = Creocore (Custom MFI approach)\n4 = RBI (India)\n5 = Principal Interest Penalties Fees Order\n6 = Interest Principal Penalties Fees Order\n7 = Early Payment Strategy\ngraceOnPrincipalPayment\nOptional: Integer - represents the number of repayment periods that grace should apply to the principal component of a repayment period.\ngraceOnInterestPayment\nOptional: Integer - represents the number of repayment periods that grace should apply to the interest component of a repayment period. Interest is still calculated but offset to later repayment periods.\ngraceOnInterestCharged\nOptional: Integer - represents the number of repayment periods that should be interest-free.\ngraceOnArrearsAgeing\nOptional: Integer - Used in Arrears calculation to only take into account loans that are more than graceOnArrearsAgeing days overdue.\noverdueDaysForNPA\nOptional: Integer - represents the maximum number of days a Loan may be overdue before being classified as a NPA (non performing asset)\naccountMovesOutOfNPAOnlyOnArrearsCompletion\nOptional: Boolean - if provided as true, Loan Account moves out of NPA state only when all arrears are cleared\naccountingRule\nSpecifies if accounting is enabled for the particular product and the type of the accounting rule to be used Example Values:1=NONE, 2=CASH_BASED, 3=ACCRUAL_PERIODIC, 4=ACCRUAL_UPFRONT\nisInterestRecalculationEnabled\nIt is a flag, Used to denote whether interest recalculation is enabled or disabled for the particular product\ndaysInYearType\nSpecifies the number of days in a year. \nExample Values:1=ACTUAL(Actual number of days in year), 360=360 DAYS, 364=364 DAYS(52 WEEKS), 365=365 DAYS\ndaysInMonthType\nSpecifies the number of days in a month. \nExample Values:1=ACTUAL(Actual number of days in month), 30=30 DAYS\ninterestRecalculationCompoundingMethod\nSpecifies which amount portion should be added to principal for interest recalculation. \nExample Values:0=NONE(Only on principal), 1=INTEREST(Principal+Interest), 2=FEE(Principal+Fee), 3=FEE And INTEREST (Principal+Fee+Interest)\nrescheduleStrategyMethod\nSpecifies what action should perform on loan repayment schedule for advance payments. \nExample Values:1=Reschedule next repayments, 2=Reduce number of installments, 3=Reduce EMI amount, 4=Adjust last, unpaid period\nrecalculationCompoundingFrequencyType\nSpecifies effective date from which the compounding of interest or fee amounts will be considered in recalculation on late payment.\nExample Values:1=Same as repayment period, 2=Daily, 3=Weekly, 4=Monthly\nrecalculationCompoundingFrequencyInterval\nSpecifies compounding frequency interval for interest recalculation.\nrecalculationCompoundingFrequencyDate\nSpecifies compounding frequency start date for interest recalculation.\nrecalculationRestFrequencyType\nSpecifies effective date from which the late or advanced payment amounts will be considered in recalculation.\nExample Values:1=Same as repayment period, 2=Daily, 3=Weekly, 4=Monthly\nrecalculationRestFrequencyInterval\nSpecifies rest frequency interval for interest recalculation.\nrecalculationRestFrequencyDate\nSpecifies rest frequency start date for interest recalculation.\npreClosureInterestCalculationStrategy\nSpecifies applicable days for interest calculation on pre closure of a loan.\nExample Values:1=Calculate till pre closure date, 2=Calculate till rest frequency date\nisArrearsBasedOnOriginalSchedule\nIf Specified as true, arrears will be identified based on original schedule.\nallowAttributeOverrides\nSpecifies if select attributes may be overridden for individual loan accounts.")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class SelfLoanProductsApiResource {
    private final LoanProductsApiResource loanProductsApiResource;
    private final AppuserClientMapperReadService appUserClientMapperReadService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAllLoanProducts(@QueryParam(value="clientId") Long clientId, @Context UriInfo uriInfo) {
        this.appUserClientMapperReadService.validateAppuserClientsMapping(clientId);
        return this.loanProductsApiResource.retrieveAllLoanProducts(uriInfo);
    }

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveLoanProductDetails(@QueryParam(value="clientId") Long clientId, @PathParam(value="productId") Long productId, @Context UriInfo uriInfo) {
        this.appUserClientMapperReadService.validateAppuserClientsMapping(clientId);
        return this.loanProductsApiResource.retrieveLoanProductDetails(productId, uriInfo);
    }

    @Generated
    public SelfLoanProductsApiResource(LoanProductsApiResource loanProductsApiResource, AppuserClientMapperReadService appUserClientMapperReadService) {
        this.loanProductsApiResource = loanProductsApiResource;
        this.appUserClientMapperReadService = appUserClientMapperReadService;
    }
}

